/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.wadi.shared;

import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.wadi.plugins.NoRoutingStrategy;
import org.codehaus.wadi.shared.HttpProxy;
import org.codehaus.wadi.shared.HttpSessionImpl;
import org.codehaus.wadi.shared.Manager;
import org.codehaus.wadi.shared.MigrationService;
import org.codehaus.wadi.shared.RoutingStrategy;
import org.codehaus.wadi.shared.StreamingStrategy;

public class ManagerProxy {
    protected final Log _log = LogFactory.getLog(this.getClass());
    protected final InetAddress _migrationAddress;
    protected final int _migrationPort;
    protected final MigrationService.Client _migrationClient;
    protected final InetAddress _httpAddress;
    protected final int _httpPort;
    protected final InetAddress _lbAddress;
    protected final int _lbPort;
    protected final String _route;
    protected final String _sessionId;

    public boolean relocateSession(Map sessions, Map locks, String id, HttpSessionImpl impl, StreamingStrategy streamingStrategy) {
        return this.migrateSessionFrom(sessions, locks, id, impl, streamingStrategy);
    }

    protected boolean migrateSessionFrom(Map sessions, Map locks, String id, HttpSessionImpl impl, StreamingStrategy streamingStrategy) {
        return this._migrationClient.run(sessions, locks, id, impl, this._migrationAddress, this._migrationPort, streamingStrategy);
    }

    public boolean relocateRequest(HttpServletRequest req, HttpServletResponse res, Manager manager) {
        if (manager.getRoutingStrategy() instanceof NoRoutingStrategy) {
            return this.proxyRequestTo(req, res);
        }
        return this.redirectRequestTo(req, res, manager);
    }

    protected boolean proxyRequestTo(HttpServletRequest req, HttpServletResponse res) {
        return HttpProxy.proxy(this._httpAddress.getHostAddress(), this._httpPort, req, res);
    }

    protected boolean redirectRequestTo(HttpServletRequest req, HttpServletResponse res, Manager manager) {
        String oldUrl;
        String oldId = req.getRequestedSessionId();
        RoutingStrategy router = manager.getRoutingStrategy();
        String root = router.strip(oldId);
        String newId = router.augment(root);
        String newUrl = oldUrl = req.getRequestURL().toString();
        if (this.isDirect(req)) {
            this._log.trace((Object)"is direct");
            try {
                URL url = new URL(oldUrl);
                String oldPrefix = String.valueOf(url.getProtocol()) + "://" + url.getHost() + (url.getPort() == url.getDefaultPort() ? "" : ":" + url.getPort());
                String newPrefix = String.valueOf(url.getProtocol()) + "://" + this._httpAddress.getHostAddress() + (this._httpPort == url.getDefaultPort() ? "" : ":" + this._httpPort);
                if (this._log.isTraceEnabled()) {
                    this._log.trace((Object)("old prefix:" + oldPrefix));
                }
                if (this._log.isTraceEnabled()) {
                    this._log.trace((Object)("new prefix:" + newPrefix));
                }
                if (this._log.isTraceEnabled()) {
                    this._log.trace((Object)("old url:" + oldUrl));
                }
                newUrl = newUrl.replaceFirst(oldPrefix, newPrefix);
                if (this._log.isTraceEnabled()) {
                    this._log.trace((Object)("new url:" + newUrl));
                }
            }
            catch (MalformedURLException e) {
                this._log.warn((Object)"unexpected problem synthesising url", (Throwable)e);
            }
        } else {
            this._log.trace((Object)"is indirect");
            if (req.isRequestedSessionIdFromCookie()) {
                ManagerProxy.rerouteSessionCookie(req, res, manager, oldId, newId);
            } else {
                if (this._log.isTraceEnabled()) {
                    this._log.trace((Object)("old url=" + oldUrl));
                }
                newUrl = oldUrl.replaceAll("jsessionid=" + oldId, "jsessionid=" + newId);
                if (this._log.isTraceEnabled()) {
                    this._log.trace((Object)("new url=" + newUrl));
                }
            }
        }
        try {
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)("redirecting: " + oldUrl + " -> " + newUrl));
            }
            res.sendRedirect(newUrl);
            return true;
        }
        catch (IOException e) {
            this._log.warn((Object)"failed to redirect request", (Throwable)e);
            return false;
        }
    }

    public static void rerouteSessionCookie(HttpServletRequest req, HttpServletResponse res, Manager manager, String oldId, String newId) {
        String cookieName = manager.getSessionCookieName();
        Cookie[] cookies = req.getCookies();
        int i = 0;
        while (i < cookies.length) {
            Cookie cookie = cookies[i];
            if (cookie.getName().equalsIgnoreCase(cookieName) && cookie.getValue().equals(oldId)) {
                String cookieDomain;
                String cookiePath = manager.getSessionCookiePath(req);
                if (cookiePath != null) {
                    cookie.setPath(cookiePath);
                }
                if ((cookieDomain = manager.getSessionCookieDomain()) != null) {
                    cookie.setDomain(cookieDomain);
                }
                cookie.setValue(newId);
                res.addCookie(cookie);
            }
            ++i;
        }
    }

    public ManagerProxy(String id, String response) throws Exception {
        this._sessionId = id;
        String[] args = response.split(",");
        this._httpAddress = InetAddress.getByName(args[3]);
        this._httpPort = Integer.parseInt(args[4]);
        this._migrationAddress = InetAddress.getByName(args[5]);
        this._migrationPort = Integer.parseInt(args[6]);
        this._migrationClient = new MigrationService.Client();
        this._lbAddress = null;
        this._lbPort = 0;
        this._route = args.length > 7 ? args[7] : null;
    }

    public boolean isDirect(HttpServletRequest req) {
        return true;
    }
}

