/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.wadi.shared;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ObjectInputStream
extends java.io.ObjectInputStream {
    private static final Log _log;
    private static final Map _primClasses;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.codehaus.wadi.shared.ObjectInputStream");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        _log = LogFactory.getLog((Class)clazz);
        _primClasses = new HashMap(8, 1.0f);
        _primClasses.put("boolean", Boolean.TYPE);
        _primClasses.put("byte", Byte.TYPE);
        _primClasses.put("char", Character.TYPE);
        _primClasses.put("short", Short.TYPE);
        _primClasses.put("int", Integer.TYPE);
        _primClasses.put("long", Long.TYPE);
        _primClasses.put("float", Float.TYPE);
        _primClasses.put("double", Double.TYPE);
        _primClasses.put("void", Void.TYPE);
    }

    ObjectInputStream(InputStream is) throws IOException {
        super(is);
    }

    protected Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        String name = desc.getName();
        try {
            return Class.forName(name, false, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException ex) {
            Class cl = (Class)_primClasses.get(name);
            if (cl != null) {
                return cl;
            }
            throw ex;
        }
    }

    public static byte[] marshall(Object value) {
        try {
            if (value == null) {
                return null;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(value);
            oos.flush();
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            _log.warn((Object)"problem marshalling attribute", (Throwable)ioe);
            return null;
        }
    }

    public static Object demarshall(byte[] buffer) {
        try {
            if (buffer == null) {
                return buffer;
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(buffer);
            ObjectInputStream ois = new ObjectInputStream(bais);
            return ois.readObject();
        }
        catch (Exception e) {
            _log.warn((Object)"problem demarshalling attribute", (Throwable)e);
            return null;
        }
    }
}

