/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.wadi.shared;

import EDU.oswego.cs.dl.util.concurrent.ReadWriteLock;
import EDU.oswego.cs.dl.util.concurrent.Sync;

public class RWLock
implements ReadWriteLock {
    protected int _maxPriority = 10;
    protected ThreadLocal _priority = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return new Integer(0);
        }
    };
    protected long activeReaders_ = 0L;
    protected Thread activeWriter_ = null;
    protected long waitingReaders_ = 0L;
    protected long waitingWriters_ = 0L;
    protected final ReaderLock readerLock_ = new ReaderLock();
    protected final WriterLock writerLock_ = new WriterLock();

    public RWLock(int maxPriority) {
        this._maxPriority = maxPriority;
    }

    public void setPriority(int priority) {
        this._priority.set(new Integer(priority));
    }

    public int getPriority() {
        return (Integer)this._priority.get();
    }

    public Sync writeLock() {
        return this.writerLock_;
    }

    public Sync readLock() {
        return this.readerLock_;
    }

    protected synchronized void cancelledWaitingReader() {
        --this.waitingReaders_;
    }

    protected synchronized void cancelledWaitingWriter(Lock l) {
        --this.waitingWriters_;
        --l._count;
    }

    protected boolean allowReader() {
        return this.activeWriter_ == null;
    }

    protected synchronized boolean startRead() {
        boolean allowRead = this.allowReader();
        if (allowRead) {
            ++this.activeReaders_;
        }
        return allowRead;
    }

    protected synchronized boolean startWrite() {
        boolean allowWrite;
        boolean bl = allowWrite = this.activeWriter_ == null && this.activeReaders_ == 0L;
        if (allowWrite) {
            this.activeWriter_ = Thread.currentThread();
        }
        return allowWrite;
    }

    protected synchronized boolean startReadFromNewReader() {
        boolean pass = this.startRead();
        if (!pass) {
            ++this.waitingReaders_;
        }
        return pass;
    }

    protected synchronized boolean startWriteFromNewWriter(Lock l) {
        boolean pass = this.startWrite();
        if (!pass) {
            ++this.waitingWriters_;
            ++l._count;
        }
        return pass;
    }

    protected synchronized boolean startReadFromWaitingReader() {
        boolean pass = this.startRead();
        if (pass) {
            --this.waitingReaders_;
        }
        return pass;
    }

    protected synchronized boolean startWriteFromWaitingWriter(Lock l) {
        boolean pass = this.startWrite();
        if (pass) {
            --this.waitingWriters_;
            --l._count;
        }
        return pass;
    }

    protected synchronized Signaller endRead() {
        if (--this.activeReaders_ == 0L && this.waitingWriters_ > 0L) {
            return this.writerLock_;
        }
        return null;
    }

    protected synchronized Signaller endWrite() {
        this.activeWriter_ = null;
        if (this.waitingReaders_ > 0L && this.allowReader()) {
            return this.readerLock_;
        }
        if (this.waitingWriters_ > 0L) {
            return this.writerLock_;
        }
        return null;
    }

    public void overlap() throws InterruptedException {
        RWLock rWLock = this;
        synchronized (rWLock) {
            Signaller s = this.endRead();
            if (s == null) {
                this.writeLock().acquire();
            } else {
                this.writeLock().acquire();
            }
        }
    }

    public String toString() {
        return "<RWLock:" + this.hashCode() + ":activeReaders:" + this.activeReaders_ + ", waitingReaders:" + this.waitingReaders_ + ", activeWriter:" + (this.activeWriter_ != null) + ", waitingWriters:" + this.waitingWriters_ + ">";
    }

    protected class Lock {
        int _count = 0;

        protected Lock() {
        }
    }

    protected abstract class Signaller {
        protected Signaller() {
        }

        abstract void signalWaiters();
    }

    protected class ReaderLock
    extends Signaller
    implements Sync {
        protected ReaderLock() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void acquire() throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            InterruptedException ie = null;
            ReaderLock readerLock = this;
            synchronized (readerLock) {
                if (!RWLock.this.startReadFromNewReader()) {
                    try {
                        do {
                            this.wait();
                        } while (!RWLock.this.startReadFromWaitingReader());
                        return;
                    }
                    catch (InterruptedException ex) {
                        RWLock.this.cancelledWaitingReader();
                        ie = ex;
                    }
                }
            }
            if (ie != null) {
                RWLock.this.writerLock_.signalWaiters();
                throw ie;
            }
        }

        public void release() {
            Signaller s = RWLock.this.endRead();
            if (s != null) {
                s.signalWaiters();
            }
        }

        synchronized void signalWaiters() {
            this.notifyAll();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean attempt(long msecs) throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            InterruptedException ie = null;
            ReaderLock readerLock = this;
            synchronized (readerLock) {
                block10: {
                    if (msecs <= 0L) {
                        return RWLock.this.startRead();
                    }
                    if (RWLock.this.startReadFromNewReader()) {
                        return true;
                    }
                    long waitTime = msecs;
                    long start = System.currentTimeMillis();
                    do {
                        try {
                            this.wait(waitTime);
                        }
                        catch (InterruptedException ex) {
                            RWLock.this.cancelledWaitingReader();
                            ie = ex;
                            break block10;
                        }
                        if (!RWLock.this.startReadFromWaitingReader()) continue;
                        return true;
                    } while ((waitTime = msecs - (System.currentTimeMillis() - start)) > 0L);
                    RWLock.this.cancelledWaitingReader();
                }
            }
            RWLock.this.writerLock_.signalWaiters();
            if (ie != null) {
                throw ie;
            }
            return false;
        }
    }

    protected class WriterLock
    extends Signaller
    implements Sync {
        Lock[] _locks;

        WriterLock() {
            this._locks = new Lock[RWLock.this._maxPriority + 1];
            int i = 0;
            while (i <= RWLock.this._maxPriority) {
                this._locks[i] = new Lock();
                ++i;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void acquire() throws InterruptedException {
            Lock l;
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            InterruptedException ie = null;
            int p = RWLock.this.getPriority();
            Lock lock = l = this._locks[p];
            synchronized (lock) {
                if (!RWLock.this.startWriteFromNewWriter(l)) {
                    try {
                        do {
                            l.wait();
                        } while (!RWLock.this.startWriteFromWaitingWriter(l));
                        return;
                    }
                    catch (InterruptedException ex) {
                        RWLock.this.cancelledWaitingWriter(l);
                        l.notify();
                        ie = ex;
                    }
                }
            }
            if (ie != null) {
                RWLock.this.readerLock_.signalWaiters();
                throw ie;
            }
        }

        public void release() {
            Signaller s = RWLock.this.endWrite();
            if (s != null) {
                s.signalWaiters();
            }
        }

        synchronized void signalWaiters() {
            int i = RWLock.this._maxPriority;
            while (i >= 0) {
                Lock l;
                Lock lock = l = this._locks[i];
                synchronized (lock) {
                    if (l._count > 0) {
                        l.notify();
                        return;
                    }
                }
                --i;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean attempt(long msecs) throws InterruptedException {
            Lock l;
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            InterruptedException ie = null;
            int p = RWLock.this.getPriority();
            Lock lock = l = this._locks[p];
            synchronized (lock) {
                block10: {
                    if (msecs <= 0L) {
                        return RWLock.this.startWrite();
                    }
                    if (RWLock.this.startWriteFromNewWriter(l)) {
                        return true;
                    }
                    long waitTime = msecs;
                    long start = System.currentTimeMillis();
                    do {
                        try {
                            l.wait(waitTime);
                        }
                        catch (InterruptedException ex) {
                            RWLock.this.cancelledWaitingWriter(l);
                            l.notify();
                            ie = ex;
                            break block10;
                        }
                        if (!RWLock.this.startWriteFromWaitingWriter(l)) continue;
                        return true;
                    } while ((waitTime = msecs - (System.currentTimeMillis() - start)) > 0L);
                    RWLock.this.cancelledWaitingWriter(l);
                    l.notify();
                }
            }
            RWLock.this.readerLock_.signalWaiters();
            if (ie != null) {
                throw ie;
            }
            return false;
        }
    }
}

