/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.wadi.test;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;

public class TestLocationClient {
    public static void main(String[] args) {
        try {
            int port = 6789;
            MulticastSocket socket = new MulticastSocket(port);
            InetAddress address = InetAddress.getByName("228.5.6.7");
            socket.setLoopbackMode(false);
            socket.joinGroup(address);
            String message = args[0];
            int numThreads = 100;
            int numIters = 100;
            Thread[] threads = new Thread[numThreads];
            int i = 0;
            while (i < numThreads) {
                threads[i] = new Thread(new Client(numIters, address, port, socket, message));
                ++i;
            }
            i = 0;
            while (i < numThreads) {
                threads[i].start();
                ++i;
            }
            i = 0;
            while (i < numThreads) {
                threads[i].join();
                ++i;
            }
            socket.leaveGroup(address);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public static class Client
    implements Runnable {
        protected final int _iters;
        protected final int _port;
        protected final InetAddress _address;
        protected final MulticastSocket _socket;
        protected final String _message;

        public Client(int iters, InetAddress address, int port, MulticastSocket socket, String message) {
            this._iters = iters;
            this._address = address;
            this._port = port;
            this._socket = socket;
            this._message = message;
        }

        public void run() {
            int i = 0;
            while (i < this._iters) {
                try {
                    this._socket.send(new DatagramPacket(this._message.getBytes(), this._message.length(), this._address, this._port));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ++i;
            }
        }
    }
}

