/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.jndi.iiop;

import java.io.Serializable;
import java.rmi.Remote;
import java.util.Hashtable;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.spi.ObjectFactory;
import org.objectweb.carol.jndi.iiop.IIOPReferenceWrapper;
import org.objectweb.carol.jndi.iiop.IIOPRemoteReference;
import org.objectweb.carol.jndi.iiop.IIOPRemoteResource;
import org.objectweb.carol.jndi.iiop.IIOPResourceWrapper;
import org.objectweb.carol.util.multi.ProtocolCurrent;

public class IIOPReferenceContextWrapper
implements Context {
    private static Context iiopContext = null;
    private static Context single = null;
    private static Hashtable wrapperHash = null;

    private IIOPReferenceContextWrapper(Context iiopCtx) throws NamingException {
        iiopContext = iiopCtx;
        wrapperHash = new Hashtable();
    }

    public static Context getSingleInstance(Hashtable env) throws NamingException {
        if (single == null) {
            env.put("java.naming.factory.initial", "com.sun.jndi.cosnaming.CNCtxFactory");
            single = new IIOPReferenceContextWrapper(new InitialContext(env));
        }
        return single;
    }

    private Object resolveObject(Object o, Name name) throws NamingException {
        try {
            if (o instanceof IIOPRemoteReference) {
                Reference objRef = ((IIOPRemoteReference)o).getReference();
                ObjectFactory objFact = (ObjectFactory)Class.forName(objRef.getFactoryClassName()).newInstance();
                return objFact.getObjectInstance(objRef, name, this, iiopContext.getEnvironment());
            }
            if (o instanceof IIOPRemoteResource) {
                return ((IIOPRemoteResource)o).getResource();
            }
            return o;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new NamingException("" + e);
        }
    }

    private Object encodeObject(Object o, Object name, boolean replace) throws NamingException {
        try {
            if (!(o instanceof Remote) && o instanceof Referenceable) {
                IIOPReferenceWrapper irw = new IIOPReferenceWrapper(((Referenceable)o).getReference());
                ProtocolCurrent.getCurrent().getCurrentPortableRemoteObject().exportObject((Remote)irw);
                IIOPReferenceWrapper oldObj = wrapperHash.put(name, irw);
                if (oldObj != null) {
                    if (replace) {
                        ProtocolCurrent.getCurrent().getCurrentPortableRemoteObject().unexportObject((Remote)oldObj);
                    } else {
                        ProtocolCurrent.getCurrent().getCurrentPortableRemoteObject().unexportObject((Remote)irw);
                        wrapperHash.put(name, oldObj);
                        throw new NamingException("Object already bind");
                    }
                }
                return irw;
            }
            if (!(o instanceof Remote) && o instanceof Reference) {
                IIOPReferenceWrapper irw = new IIOPReferenceWrapper((Reference)o);
                ProtocolCurrent.getCurrent().getCurrentPortableRemoteObject().exportObject((Remote)irw);
                IIOPReferenceWrapper oldObj = wrapperHash.put(name, irw);
                if (oldObj != null) {
                    if (replace) {
                        ProtocolCurrent.getCurrent().getCurrentPortableRemoteObject().unexportObject((Remote)oldObj);
                    } else {
                        ProtocolCurrent.getCurrent().getCurrentPortableRemoteObject().unexportObject((Remote)irw);
                        wrapperHash.put(name, oldObj);
                        throw new NamingException("Object already bind");
                    }
                }
                return irw;
            }
            if (!(o instanceof Remote) && o instanceof Serializable) {
                IIOPResourceWrapper irw = new IIOPResourceWrapper((Serializable)o);
                ProtocolCurrent.getCurrent().getCurrentPortableRemoteObject().exportObject((Remote)irw);
                IIOPResourceWrapper oldObj = wrapperHash.put(name, irw);
                if (oldObj != null) {
                    if (replace) {
                        ProtocolCurrent.getCurrent().getCurrentPortableRemoteObject().unexportObject((Remote)oldObj);
                    } else {
                        ProtocolCurrent.getCurrent().getCurrentPortableRemoteObject().unexportObject((Remote)irw);
                        wrapperHash.put(name, oldObj);
                        throw new NamingException("Object already bind");
                    }
                }
                return irw;
            }
            return o;
        }
        catch (Exception e) {
            throw new NamingException("" + e);
        }
    }

    public Object lookup(String name) throws NamingException {
        return this.resolveObject(iiopContext.lookup(name), new CompositeName(name));
    }

    public Object lookup(Name name) throws NamingException {
        return this.resolveObject(iiopContext.lookup(name), name);
    }

    public void bind(String name, Object obj) throws NamingException {
        iiopContext.bind(name, this.encodeObject(obj, name, false));
    }

    public void bind(Name name, Object obj) throws NamingException {
        iiopContext.bind(name, this.encodeObject(obj, name, false));
    }

    public void rebind(String name, Object obj) throws NamingException {
        iiopContext.rebind(name, this.encodeObject(obj, name, true));
    }

    public void rebind(Name name, Object obj) throws NamingException {
        iiopContext.rebind(name, this.encodeObject(obj, name, true));
    }

    public void unbind(String name) throws NamingException {
        try {
            iiopContext.unbind(name);
            if (wrapperHash.containsKey(name)) {
                ProtocolCurrent.getCurrent().getCurrentPortableRemoteObject().unexportObject((Remote)wrapperHash.remove(name));
            }
        }
        catch (Exception e) {
            throw new NamingException("" + e);
        }
    }

    public void unbind(Name name) throws NamingException {
        try {
            iiopContext.unbind(name);
            if (wrapperHash.containsKey(name)) {
                ProtocolCurrent.getCurrent().getCurrentPortableRemoteObject().unexportObject((Remote)wrapperHash.remove(name));
            }
        }
        catch (Exception e) {
            throw new NamingException("" + e);
        }
    }

    public void rename(String oldName, String newName) throws NamingException {
        if (wrapperHash.containsKey(oldName)) {
            wrapperHash.put(newName, wrapperHash.remove(oldName));
        }
        iiopContext.rename(oldName, newName);
    }

    public void rename(Name oldName, Name newName) throws NamingException {
        if (wrapperHash.containsKey(oldName)) {
            wrapperHash.put(newName, wrapperHash.remove(oldName));
        }
        iiopContext.rename(oldName, newName);
    }

    public NamingEnumeration list(String name) throws NamingException {
        return iiopContext.list(name);
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return iiopContext.list(name);
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        return iiopContext.listBindings(name);
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return iiopContext.listBindings(name);
    }

    public void destroySubcontext(String name) throws NamingException {
        iiopContext.destroySubcontext(name);
    }

    public void destroySubcontext(Name name) throws NamingException {
        iiopContext.destroySubcontext(name);
    }

    public Context createSubcontext(String name) throws NamingException {
        return iiopContext.createSubcontext(name);
    }

    public Context createSubcontext(Name name) throws NamingException {
        return iiopContext.createSubcontext(name);
    }

    public Object lookupLink(String name) throws NamingException {
        return iiopContext.lookupLink(name);
    }

    public Object lookupLink(Name name) throws NamingException {
        return iiopContext.lookupLink(name);
    }

    public NameParser getNameParser(String name) throws NamingException {
        return iiopContext.getNameParser(name);
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return iiopContext.getNameParser(name);
    }

    public String composeName(String name, String prefix) throws NamingException {
        return name;
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        return (Name)name.clone();
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return iiopContext.addToEnvironment(propName, propVal);
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        return iiopContext.removeFromEnvironment(propName);
    }

    public Hashtable getEnvironment() throws NamingException {
        return iiopContext.getEnvironment();
    }

    public void close() throws NamingException {
    }

    public String getNameInNamespace() throws NamingException {
        return iiopContext.getNameInNamespace();
    }
}

