/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.jndi.ns;

import org.objectweb.carol.cmi.ClusterRegistryImpl;
import org.objectweb.carol.cmi.ClusterRegistryKiller;
import org.objectweb.carol.cmi.DistributedEquiv;
import org.objectweb.carol.jndi.ns.NameService;
import org.objectweb.carol.jndi.ns.NameServiceException;
import org.objectweb.carol.util.configuration.TraceCarol;

public class CmiRegistry
implements NameService {
    private int port = 12341;
    private DistributedEquiv de = null;
    private ClusterRegistryKiller cregk = null;

    public void start() throws NameServiceException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("CmiRegistry.start() on port:" + this.port);
        }
        try {
            if (!this.isStarted()) {
                if (this.port >= 0) {
                    this.de = DistributedEquiv.start();
                    this.cregk = ClusterRegistryImpl.start(this.port);
                    Runtime.getRuntime().addShutdownHook(new Thread(){

                        public void run() {
                            try {
                                CmiRegistry.this.stop();
                            }
                            catch (Exception e) {
                                TraceCarol.error("CmiRegistry ShutdownHook problem", e);
                            }
                        }
                    });
                } else if (TraceCarol.isDebugJndiCarol()) {
                    TraceCarol.debugJndiCarol("Can't start CmiRegistry, port=" + this.port + " is < 0");
                }
            } else if (TraceCarol.isDebugJndiCarol()) {
                TraceCarol.debugJndiCarol("CmiRegistry is already start on port:" + this.port);
            }
        }
        catch (Exception e) {
            throw new NameServiceException("can not start cluster registry: " + e);
        }
    }

    public void stop() throws NameServiceException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("CmiRegistry.stop()");
        }
        try {
            if (this.cregk != null) {
                this.cregk.stop();
                this.de.stop();
                this.cregk = null;
            }
        }
        catch (Exception e) {
            throw new NameServiceException("can not stop cluster registry: " + e);
        }
    }

    public boolean isStarted() {
        return this.cregk != null;
    }

    public void setPort(int p) {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("CmiRegistry.setPort(" + p + ")");
        }
        if (p != 0) {
            this.port = p;
        }
    }

    public int getPort() {
        return this.port;
    }
}

