/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util.jmx;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.Iterator;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.loading.MLet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mortbay.util.Resource;
import org.mortbay.util.jmx.ModelMBeanImpl;

public class Main {
    private static Log log = LogFactory.getLog((Class)(class$org$mortbay$util$jmx$Main == null ? (class$org$mortbay$util$jmx$Main = Main.class$("org.mortbay.util.jmx.Main")) : class$org$mortbay$util$jmx$Main));
    static MLet mlet;
    static MBeanServer server;
    static /* synthetic */ Class class$org$mortbay$util$jmx$Main;
    static /* synthetic */ Class class$java$lang$Thread;
    static /* synthetic */ Class class$java$lang$Runtime;

    static void startMLet(String[] arg) {
        try {
            server = MBeanServerFactory.createMBeanServer(ModelMBeanImpl.getDefaultDomain());
            if (log.isDebugEnabled()) {
                log.debug((Object)("MBeanServer=" + server));
            }
            mlet = new MLet(new URL[0], Thread.currentThread().getContextClassLoader());
            server.registerMBean(mlet, new ObjectName(server.getDefaultDomain(), "service", "MLet"));
            if (log.isDebugEnabled()) {
                log.debug((Object)("MLet=" + mlet));
            }
            Thread.currentThread().setContextClassLoader(mlet);
            int i = 0;
            while (i < arg.length) {
                log.info((Object)("Load " + arg[i]));
                Resource resource = Resource.newResource((String)arg[i]);
                Set<Object> beans = mlet.getMBeansFromURL(resource.getURL().toString());
                Iterator<Object> iter = beans.iterator();
                while (iter.hasNext()) {
                    Object bean = iter.next();
                    if (bean instanceof Throwable) {
                        iter.remove();
                        log.warn((Object)((Throwable)bean));
                        continue;
                    }
                    if (!(bean instanceof ObjectInstance)) continue;
                    ObjectInstance oi = (ObjectInstance)bean;
                    if ("com.sun.jdmk.comm.HtmlAdaptorServer".equals(oi.getClassName())) {
                        log.info((Object)"Starting com.sun.jdmk.comm.HtmlAdaptorServer");
                        try {
                            server.invoke(oi.getObjectName(), "start", null, null);
                        }
                        catch (Exception e) {
                            log.warn((Object)"EXCEPTION ", (Throwable)e);
                        }
                        continue;
                    }
                    if (!"mx4j.adaptor.rmi.jrmp.JRMPAdaptor".equals(oi.getClassName())) continue;
                    Object[] jndinameargs = new Object[]{"jrmp"};
                    String[] jndinametype = new String[]{"java.lang.String"};
                    Object[] jndiportargs = new Object[]{new Integer(1099)};
                    String[] jndiporttype = new String[]{"int"};
                    log.info((Object)"Starting mx4j.tools.naming.NamingService");
                    ObjectName naming = new ObjectName("Naming:type=rmiregistry");
                    server.createMBean("mx4j.tools.naming.NamingService", naming, null);
                    server.invoke(naming, "start", null, null);
                    try {
                        server.invoke(oi.getObjectName(), "setJNDIName", jndinameargs, jndinametype);
                        server.invoke(oi.getObjectName(), "setPort", jndiportargs, jndiporttype);
                    }
                    catch (Exception e) {
                        log.warn((Object)e);
                    }
                    log.info((Object)"Starting mx4j.adaptor.rmi.jrmp.JRMPAdaptor");
                    try {
                        server.invoke(oi.getObjectName(), "start", null, null);
                    }
                    catch (Exception e) {
                        log.warn((Object)e);
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Loaded " + beans.size() + " MBeans: " + beans));
                }
                ++i;
            }
        }
        catch (Exception e) {
            log.warn((Object)"EXCEPTION ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] arg) throws Exception {
        if (arg.length == 0) {
            System.err.println("Usage - java org.mortbay.util.jmx.Main <mletURL>...");
            System.exit(1);
        }
        Main.startMLet(arg);
        if (!Boolean.getBoolean("JETTY_NO_SHUTDOWN_HOOK")) {
            try {
                Method shutdownHook = (class$java$lang$Runtime == null ? (class$java$lang$Runtime = Main.class$("java.lang.Runtime")) : class$java$lang$Runtime).getMethod("addShutdownHook", class$java$lang$Thread == null ? (class$java$lang$Thread = Main.class$("java.lang.Thread")) : class$java$lang$Thread);
                Thread hook = new Thread(){

                    public void run() {
                        this.setName("Shutdown");
                        log.info((Object)"Shutdown hook executing");
                        Set<ObjectName> registeredNames = null;
                        try {
                            registeredNames = server.queryNames(new ObjectName("org.mortbay:Server=0"), null);
                        }
                        catch (MalformedObjectNameException e) {
                            log.warn((Object)"Malformed JMX-Object-Name", (Throwable)e);
                        }
                        Iterator<ObjectName> i = registeredNames.iterator();
                        while (i.hasNext()) {
                            ObjectName name = i.next();
                            try {
                                if (!server.isRegistered(name) || server.isInstanceOf(name, "javax.management.MBeanServerDelegate")) continue;
                                server.unregisterMBean(name);
                            }
                            catch (Exception e) {
                                if (name != null) {
                                    String bname = name.getCanonicalName();
                                    log.warn((Object)("could not unregister mbean: " + bname + " Exception: " + e));
                                    continue;
                                }
                                log.warn((Object)("could not unregister mbean. Exception: " + e));
                            }
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Exception e) {
                            log.warn((Object)e);
                        }
                    }
                };
                shutdownHook.invoke((Object)Runtime.getRuntime(), hook);
            }
            catch (Exception e) {
                log.debug((Object)"No shutdown hook in JVM ", (Throwable)e);
            }
        }
        try {
            MLet e = mlet;
            synchronized (e) {
                mlet.wait();
            }
        }
        catch (Exception e) {
            log.info((Object)("Exception:" + e));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        server = null;
    }
}

