/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.PathMap;
import org.mortbay.jetty.servlet.Holder;
import org.mortbay.jetty.servlet.WebApplicationHandler;
import org.mortbay.util.LazyList;

public class FilterHolder
extends Holder {
    public static final int __REQUEST = 1;
    public static final int __FORWARD = 2;
    public static final int __INCLUDE = 4;
    public static final int __ERROR = 8;
    public static final int __ALL = 15;
    private PathMap _pathSpecs;
    private int _appliesTo;
    private Object _servlets;
    private transient Filter _filter;
    private transient Config _config;
    static /* synthetic */ Class class$javax$servlet$Filter;

    public static int type(String type) {
        if ("request".equalsIgnoreCase(type)) {
            return 1;
        }
        if ("forward".equalsIgnoreCase(type)) {
            return 2;
        }
        if ("include".equalsIgnoreCase(type)) {
            return 4;
        }
        if ("error".equalsIgnoreCase(type)) {
            return 8;
        }
        return 0;
    }

    public FilterHolder() {
    }

    public FilterHolder(HttpHandler httpHandler, String name, String className) {
        super(httpHandler, name, className);
    }

    public void addAppliesTo(int type) {
        this._appliesTo |= type;
    }

    public void addAppliesTo(String type) {
        this._appliesTo |= FilterHolder.type(type);
    }

    public void addServlet(String servlet) {
        this._servlets = LazyList.add(this._servlets, servlet);
    }

    public void addPathSpec(String pathSpec) {
        if (this._pathSpecs == null) {
            this._pathSpecs = new PathMap();
        }
        this._pathSpecs.put(pathSpec, pathSpec);
    }

    public boolean isMappedToPath() {
        return this._pathSpecs != null;
    }

    public boolean appliesTo(int type) {
        return (this._appliesTo & type) != 0 || this._appliesTo == 0 && type == 1;
    }

    public boolean appliesTo(String path, int type) {
        return ((this._appliesTo & type) != 0 || this._appliesTo == 0 && type == 1) && this._pathSpecs != null && this._pathSpecs.getMatch(path) != null;
    }

    public String appliedPathSpec(String path) {
        if (this._pathSpecs == null) {
            return null;
        }
        Map.Entry entry = this._pathSpecs.getMatch(path);
        if (entry == null) {
            return null;
        }
        return (String)entry.getKey();
    }

    public void start() throws Exception {
        super.start();
        if (!(class$javax$servlet$Filter == null ? (class$javax$servlet$Filter = FilterHolder.class$("javax.servlet.Filter")) : class$javax$servlet$Filter).isAssignableFrom(this._class)) {
            super.stop();
            throw new IllegalStateException(this._class + " is not a javax.servlet.Filter");
        }
        this._filter = (Filter)this.newInstance();
        this._config = new Config();
        this._filter.init(this._config);
    }

    public void stop() {
        if (this._filter != null) {
            this._filter.destroy();
        }
        this._filter = null;
        this._config = null;
        super.stop();
    }

    public Filter getFilter() {
        return this._filter;
    }

    public String[] getPaths() {
        if (this._pathSpecs == null) {
            return null;
        }
        int s = this._pathSpecs.keySet().size();
        return this._pathSpecs.keySet().toArray(new String[s]);
    }

    public String[] getServlets() {
        if (this._servlets == null) {
            return null;
        }
        int s = LazyList.size(this._servlets);
        return LazyList.getList(this._servlets).toArray(new String[s]);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getName());
        buf.append('[');
        buf.append(this.getClassName());
        int i = 0;
        while (i < LazyList.size(this._servlets)) {
            buf.append(',');
            buf.append(LazyList.get(this._servlets, i));
            ++i;
        }
        if (this._pathSpecs != null) {
            Iterator iter = this._pathSpecs.keySet().iterator();
            while (iter.hasNext()) {
                buf.append(',');
                buf.append(iter.next());
            }
        }
        buf.append(']');
        return buf.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class Config
    implements FilterConfig {
        Config() {
        }

        public String getFilterName() {
            return FilterHolder.this.getName();
        }

        public ServletContext getServletContext() {
            return ((WebApplicationHandler)FilterHolder.this._httpHandler).getServletContext();
        }

        public String getInitParameter(String param) {
            return FilterHolder.this.getInitParameter(param);
        }

        public Enumeration getInitParameterNames() {
            return FilterHolder.this.getInitParameterNames();
        }
    }
}

