/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.cmi;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;

public class WeakCache {
    private HashMap table = new HashMap();
    private static ReferenceQueue rQueue = new ReferenceQueue();
    private static Thread rQueueThread = new RefQueueFlush();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getCached(Object obj) {
        WeakRef wr = new WeakRef(obj, rQueue);
        HashMap hashMap = this.table;
        synchronized (hashMap) {
            WeakRef cached = (WeakRef)this.table.get(wr);
            if (cached == null) {
                this.table.put(wr, wr);
                return obj;
            }
            Object c = cached.get();
            if (c == null) {
                this.table.remove(cached);
                this.table.put(wr, wr);
                return obj;
            }
            return c;
        }
    }

    static {
        rQueueThread.setDaemon(true);
        rQueueThread.start();
    }

    private static class RefQueueFlush
    extends Thread {
        public void run() {
            while (true) {
                try {
                    WeakRef wr = (WeakRef)rQueue.remove();
                    wr.remove();
                }
                catch (InterruptedException e) {
                }
            }
        }
    }

    private class WeakRef
    extends WeakReference {
        private int hash;

        public WeakRef(Object obj) {
            super(obj);
            this.hash = obj.hashCode();
        }

        public WeakRef(Object obj, ReferenceQueue rq) {
            super(obj, rq);
            this.hash = obj.hashCode();
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof WeakRef) {
                Object o = this.get();
                return o != null && o.equals(((WeakRef)obj).get());
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove() {
            HashMap hashMap = WeakCache.this.table;
            synchronized (hashMap) {
                WeakCache.this.table.remove(this);
            }
        }
    }
}

