/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jaas;

import java.security.Principal;
import java.util.HashMap;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.UserRealm;
import org.mortbay.jaas.JAASUserPrincipal;
import org.mortbay.jaas.RoleCheckPolicy;
import org.mortbay.jaas.callback.AbstractCallbackHandler;
import org.mortbay.jaas.callback.DefaultCallbackHandler;
import org.mortbay.util.Loader;

public class JAASUserRealm
implements UserRealm {
    private static Log log = LogFactory.getLog((Class)(class$org$mortbay$jaas$JAASUserRealm == null ? (class$org$mortbay$jaas$JAASUserRealm = JAASUserRealm.class$("org.mortbay.jaas.JAASUserRealm")) : class$org$mortbay$jaas$JAASUserRealm));
    protected String callbackHandlerClass;
    protected String realmName;
    protected String loginModuleName;
    protected HashMap userMap = new HashMap();
    protected RoleCheckPolicy roleCheckPolicy;
    static /* synthetic */ Class class$org$mortbay$jaas$JAASUserRealm;

    public JAASUserRealm() {
    }

    public JAASUserRealm(String name) {
        this();
        this.realmName = name;
    }

    public String getName() {
        return this.realmName;
    }

    public void setName(String name) {
        this.realmName = name;
    }

    public void setLoginModuleName(String name) {
        this.loginModuleName = name;
    }

    public void setCallbackHandlerClass(String classname) {
        this.callbackHandlerClass = classname;
    }

    public void setRoleCheckPolicy(RoleCheckPolicy policy) {
        this.roleCheckPolicy = policy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Principal getPrincipal(String username) {
        JAASUserRealm jAASUserRealm = this;
        synchronized (jAASUserRealm) {
            return (Principal)this.userMap.get(username);
        }
    }

    public boolean isUserInRole(Principal user, String role) {
        if (user instanceof JAASUserPrincipal) {
            return ((JAASUserPrincipal)user).isUserInRole(role);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reauthenticate(Principal user) {
        JAASUserRealm jAASUserRealm = this;
        synchronized (jAASUserRealm) {
            return this.userMap.get(user.getName()) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Principal authenticate(String username, Object credentials, HttpRequest request) {
        try {
            UserInfo info = null;
            JAASUserRealm jAASUserRealm = this;
            synchronized (jAASUserRealm) {
                info = (UserInfo)this.userMap.get(username);
            }
            if (info != null) {
                jAASUserRealm = this;
                synchronized (jAASUserRealm) {
                    this.userMap.remove(username);
                }
            }
            AbstractCallbackHandler callbackHandler = null;
            if (this.callbackHandlerClass == null) {
                log.warn((Object)"No CallbackHandler configured: using DefaultCallbackHandler");
                callbackHandler = new DefaultCallbackHandler();
            } else {
                callbackHandler = (AbstractCallbackHandler)Loader.loadClass((Class)(class$org$mortbay$jaas$JAASUserRealm == null ? (class$org$mortbay$jaas$JAASUserRealm = JAASUserRealm.class$("org.mortbay.jaas.JAASUserRealm")) : class$org$mortbay$jaas$JAASUserRealm), (String)this.callbackHandlerClass).getConstructors()[0].newInstance(new Object[0]);
            }
            if (callbackHandler instanceof DefaultCallbackHandler) {
                ((DefaultCallbackHandler)callbackHandler).setRequest(request);
            }
            callbackHandler.setUserName(username);
            callbackHandler.setCredential(credentials);
            LoginContext loginContext = new LoginContext(this.loginModuleName, callbackHandler);
            loginContext.login();
            JAASUserPrincipal userPrincipal = new JAASUserPrincipal(username);
            userPrincipal.setSubject(loginContext.getSubject());
            userPrincipal.setRoleCheckPolicy(this.roleCheckPolicy);
            JAASUserRealm jAASUserRealm2 = this;
            synchronized (jAASUserRealm2) {
                this.userMap.put(username, new UserInfo(username, userPrincipal, loginContext));
            }
            return userPrincipal;
        }
        catch (Exception e) {
            log.warn((Object)e);
            return null;
        }
    }

    public void disassociate(Principal user) {
        if (user != null) {
            ((JAASUserPrincipal)user).disassociate();
        }
    }

    public Principal pushRole(Principal user, String role) {
        ((JAASUserPrincipal)user).pushRole(role);
        return user;
    }

    public Principal popRole(Principal user) {
        ((JAASUserPrincipal)user).popRole();
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logout(Principal user) {
        try {
            if (!(user instanceof JAASUserPrincipal)) {
                throw new IllegalArgumentException(user + " is not a JAASUserPrincipal");
            }
            String key = ((JAASUserPrincipal)user).getName();
            UserInfo info = null;
            JAASUserRealm jAASUserRealm = this;
            synchronized (jAASUserRealm) {
                info = (UserInfo)this.userMap.get(key);
            }
            if (info == null) {
                log.warn((Object)("Logout called for user=" + user + " who is NOT in the authentication cache"));
            } else {
                info.getLoginContext().logout();
            }
            jAASUserRealm = this;
            synchronized (jAASUserRealm) {
                this.userMap.remove(key);
            }
            log.debug((Object)(user + " has been LOGGED OUT"));
        }
        catch (LoginException e) {
            log.warn((Object)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class UserInfo {
        String name;
        JAASUserPrincipal principal;
        LoginContext context;

        public UserInfo(String name, JAASUserPrincipal principal, LoginContext context) {
            this.name = name;
            this.principal = principal;
            this.context = context;
        }

        public String getName() {
            return this.name;
        }

        public JAASUserPrincipal getJAASUserPrincipal() {
            return this.principal;
        }

        public LoginContext getLoginContext() {
            return this.context;
        }
    }
}

