/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.howl.log.xa;

import org.objectweb.howl.log.LogException;
import org.objectweb.howl.log.TestDriver;
import org.objectweb.howl.log.TestWorker;
import org.objectweb.howl.log.xa.XACommittingTx;
import org.objectweb.howl.log.xa.XALogger;

public class XAWorker
extends TestWorker {
    final XALogger xalog;

    public XAWorker(TestDriver driver) {
        super(driver);
        this.xalog = (XALogger)this.log;
    }

    public XACommittingTx logCommit(int id) throws LogException, Exception {
        this.updateRecordData(id);
        this.bytesLogged += (long)this.commitData.length;
        return this.xalog.putCommit(this.commitDataRecord);
    }

    public void logDone(XACommittingTx tx) throws LogException, Exception {
        this.xalog.putDone(this.doneDataRecord, tx);
        this.bytesLogged += (long)this.doneData.length;
        ++this.transactions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.delayBeforeDone > 0L) {
            this.count = 4;
        }
        try {
            this.driver.getStartBarrier().barrier();
            for (int i = 1; i <= this.count; ++i) {
                long startTime = System.currentTimeMillis();
                XACommittingTx tx = this.logCommit(i);
                if (this.delayBeforeDone > 0L) {
                    XAWorker.sleep(this.delayBeforeDone);
                }
                this.logDone(tx);
                this.latency += System.currentTimeMillis() - startTime;
            }
        }
        catch (Exception e) {
            this.exception = e;
            System.err.println(e.toString());
        }
        finally {
            this.driver.getStopBarrier().release();
        }
    }
}

