#ifndef GTKUTILS_H__
#define GTKUTILS_H__

#include <gtk/gtk.h>

/** A tree sort function. */
typedef gint (*compr_func)(GtkTreeModel *model, GtkTreeIter *a, 
			   GtkTreeIter *b, gpointer user_data);

/** Add a menu item to a menu. 
 * @param menu the menu to add an item to.
 * @param text the text of the menu item.
 * @param func the method to be called when the menu item is selected.
 */
void add_menu_item (GtkWidget* menu, char* text, GCallback func);

/** Add a menu separator to a menu.
 * @param menu the menu to add the separator to.
 */
void add_menu_separator (GtkWidget* menu);

/** Add a label to a GtkTable
 * @param text the text to add.
 * @param table the table to add the label to.
 * @param col the column to add the label at.
 * @param row the row to add the label at.
 */
void add_left_label_to_table (char* text, GtkWidget* table, 
			      int row, int col);


/** Get a GtkTable for a given set of labels and functions giving value.
 * @param labels the text for the labels.
 * @param funcs the methods giving the value for the row.
 * @param v the value that the tablefuncs operate on.
 */
typedef char* (*tablefunc)(void*);
GtkWidget* get_table (gchar** labels, tablefunc funcs[], void* v);

/** Add a column to a tree. 
 * @param tree the tree to add a column to
 * @param label the name of the column
 * @param pos the position of the column
 * @param data the extra data to be passed to the callback function
 * @param cb the callback function for header clicks
 * @param width the starting column width
 * @param align the column alignment. 0 = left, 0.5 = center, 1 = right.
 */
void add_column (GtkWidget* tree, char* label, int pos, 
		 gpointer data, 
		 void (*cb)(GtkWidget*, gpointer), 
		 gint width, 
		 int align); 

typedef void (*add_row_func)(void*, int, GtkTreeIter*);

/** updates a tree with new data. 
 */
void update_tree (GtkListStore* list, int count, int max_rows, void** items, 
		  add_row_func add_row_to_list, int current_size);

/** Set the status text on the given status bar */
void set_status_internal (GtkWidget *statusbar, char* text);

/** Ignore delete event. */
gint ignore_delete_event (GtkWidget *widget, GdkEvent  *event, gpointer   data);

/** calls gtk_main_quit. */
void destroy (GtkWidget *widget, gpointer data);

#endif /* GTKUTILS_H__ */

/* Emacs Local Variables: */
/* Emacs mode:C */
/* Emacs c-indentation-style:"gnu" */
/* Emacs c-hanging-braces-alist:((brace-list-open)(brace-entry-open)(defun-open after)(substatement-open after)(block-close . c-snug-do-while)(extern-lang-open after)) */
/* Emacs c-cleanup-list:(brace-else-brace brace-elseif-brace space-before-funcall) */
/* Emacs c-basic-offset:4 */
/* Emacs End: */
