#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <jvmpi.h>

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <obj.h>
#include <objectstore.h>

/** Create a new objectstore.
 */
objectstore* objectstore_new () {
    objectstore* os;
    os = malloc (sizeof (*os));
    if (!os) {
	fprintf(stderr,"objectstore_new: out of memory\n");
	exit(1);
    }

    os->free_list = NULL;
    os->buf = NULL;
    os->size = 0;
    return os;
}

/** Delete the given objectstore. */
void objectstore_free (objectstore* os) {    
    obj_buffer* oo;
    if (os == NULL)
	return;
    while ((oo = os->buf)) {
	os->buf = os->buf->next;
	free (oo->buf);
	free (oo);
    }
    free (os);
}

static void create_new_buffer (objectstore* os) {
    obj_buffer* nb;
    int i;
    int size = 8192;
    nb = malloc (sizeof (*nb));
    if (nb == NULL)
	return;
    nb->next = os->buf;
    os->buf = nb;
    nb->buf = malloc (sizeof (*nb->buf) * size);
    if (nb->buf == NULL) {
	free (nb);
	return;
    }
    for (i = 0; i < size - 1; i++) 
	nb->buf[i].next_free = nb->buf + i + 1;
    nb->buf[i].next_free = os->free_list;
    os->free_list = nb->buf;    
}

/** Create a new object on the objectstore. Return the array index.
 */
obj* objectstore_obj_new (objectstore* os, jint arena_id, cls* class_id, 
			  jint is_array, jint size, jobjectID obj_id, 
			  method* method, int level) {
    obj_obs* ret;
    
    if (os->free_list == NULL) {
	//fprintf (stderr, "free_list empty, allocating new...\n");
	create_new_buffer (os);
    }
    ret = os->free_list;
    if (!ret) {
	fprintf(stderr,"objectstore_obj_new: out of memory!\n");
	exit(1);
    }
    os->free_list = ret->next_free;
    os->size++;
    
    ret->o.arena_id = arena_id;
    ret->o.clz = class_id;
    ret->o.is_array = is_array;
    ret->o.size = size;
    ret->o.obj_id = obj_id;
    ret->o.method = method;
    ret->o.level = level;
    return (obj*)ret;
}

/** Destroy an object on the objectstore
 */
void objectstore_obj_free (objectstore* os, obj* o) {
    obj_obs* oo = (obj_obs*)o;
    oo->next_free = os->free_list;
    os->free_list = oo;
    os->size--;
}


/* Emacs Local Variables: */
/* Emacs mode:C */
/* Emacs c-indentation-style:"gnu" */
/* Emacs c-hanging-braces-alist:((brace-list-open)(brace-entry-open)(defun-open after)(substatement-open after)(block-close . c-snug-do-while)(extern-lang-open after)) */
/* Emacs c-cleanup-list:(brace-else-brace brace-elseif-brace space-before-funcall) */
/* Emacs c-basic-offset:4 */
/* Emacs End: */
