#ifndef UI_H__
#define UI_H__

#include <hash.h>
#include <deadlock_detector.h>

enum {
    OCLASS_COLUMN,
    OINSTANCE_COLUMN,
    OINSTANCE_MAX_COLUMN,
    OSIZE_COLUMN,
    OGC_COLUMN,
    OTENURE_COLUMN,
    OOBJECT_COLUMN,  /* pointer to the cls, please keep next to last */
    ON_COLUMNS
};

/** do any special ui initialization. */
void init_ui (void);

/** The thread used to run gtk-main. 
 */
void gtkthread (void* data);

/** Tell the ui system to shut itself down. */
void quit_ui (void);

/** Update the statistics. */
void updateUI (hashtab* cls, hashtab* methods);

/** Return the id of the dump file. */
int dump_data (char* dumpfile, hashtab* cls, hashtab* methods, hashtab* threads);

/** Set the dump timer... */
void set_dump_timer (int dumptimer);

/** Get the current dump timer. */
int get_dump_timer (void);

/** Set the status text on the main status bar, no locking is done, 
 *  so only do this from the ui-thread ... 
*/
void set_status (char* text);

/** Set the status text on the main status bar, locks the ui-structures
 *  so use this from outside the ui-thread.
 */
void set_status_lock (char* text);

/** Check if we have any ui-handling to do. */
int events_pending (void);

/** Update the ui-toolkit (gtk_main_iteration ()) */
int ui_iteration (void);

/** Show deadlock */
void show_deadlock (visited_threads* vt);

#endif /* UI_H__ */

/* Emacs Local Variables: */
/* Emacs mode:C */
/* Emacs c-indentation-style:"gnu" */
/* Emacs c-hanging-braces-alist:((brace-list-open)(brace-entry-open)(defun-open after)(substatement-open after)(block-close . c-snug-do-while)(extern-lang-open after)) */
/* Emacs c-cleanup-list:(brace-else-brace brace-elseif-brace space-before-funcall) */
/* Emacs c-basic-offset:4 */
/* Emacs End: */
