/*
 * Decompiled with CFR 0.152.
 */
package com.mentorgen.tools.profile.runtime;

import com.mentorgen.tools.profile.runtime.Frame;
import com.mentorgen.tools.profile.runtime.InteractionList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ThreadDictionary
extends HashMap<Long, InteractionList> {
    ThreadDictionary() {
    }

    void add(long l, Frame frame) {
        InteractionList interactionList = (InteractionList)this.get(l);
        if (interactionList == null) {
            interactionList = new InteractionList();
            this.put(l, interactionList);
        }
        interactionList.add(frame);
    }

    Frame getMostRecentFrame(long l) {
        return (Frame)((InteractionList)this.get(l)).getLast();
    }

    Iterable<Long> threads() {
        return this.keySet();
    }

    Iterable<Frame> interactions(long l) {
        return (Iterable)this.get(l);
    }

    long getThreadTotalTime(long l) {
        InteractionList interactionList = (InteractionList)this.get(l);
        assert (interactionList != null);
        long l2 = 0L;
        for (Frame frame : interactionList) {
            l2 += frame._metrics.getTotalTime();
        }
        return l2;
    }
}

