/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.bsf;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.apache.bsf.BSFDeclaredBean;
import org.apache.bsf.BSFEngine;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.apache.bsf.util.BSFEngineImpl;
import org.apache.bsf.util.BSFFunctions;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.embed.BiVariable;
import org.jruby.embed.EmbedEvalUnit;
import org.jruby.embed.EmbedRubyObjectAdapter;
import org.jruby.embed.LocalContextScope;
import org.jruby.embed.LocalVariableBehavior;
import org.jruby.embed.PathType;
import org.jruby.embed.ScriptingContainer;
import org.jruby.embed.util.SystemPropertyCatcher;
import org.jruby.embed.variable.VariableInterceptor;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.IAccessor;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRubyEngine
extends BSFEngineImpl {
    private static final String bsfProps = "org/jruby/embed/bsf/BsfJRubyEngine.properties";
    private ScriptingContainer container;

    public Object apply(String file, int line, int col, Object funcBody, Vector paramNames, Vector args) {
        ThreadContext context = this.container.getRuntime().getCurrentContext();
        try {
            if (paramNames != null && args != null) {
                for (int i = 0; i < paramNames.size(); ++i) {
                    Object o = paramNames.get(i);
                    if (!(o instanceof String)) continue;
                    String name = (String)o;
                    this.container.put(name, args.get(i));
                }
            }
            return this.run(file, line, funcBody);
        }
        catch (StackOverflowError soe) {
            throw context.getRuntime().newSystemStackError("stack level too deep", soe);
        }
    }

    private Object run(String fileinfo, int line, Object scriptUnit) {
        EmbedEvalUnit unit = null;
        if (scriptUnit instanceof String) {
            unit = this.container.parse(scriptUnit.toString(), line);
        } else if (scriptUnit instanceof Reader) {
            unit = this.container.parse((Reader)scriptUnit, fileinfo, line);
        } else if (scriptUnit instanceof InputStream) {
            unit = this.container.parse((InputStream)scriptUnit, fileinfo, line);
        } else if (scriptUnit instanceof PathType) {
            unit = this.container.parse((PathType)((Object)scriptUnit), fileinfo, line);
        }
        if (unit == null) {
            return null;
        }
        IRubyObject ret = unit.run();
        return JavaEmbedUtils.rubyToJava((IRubyObject)ret);
    }

    public Object eval(String file, int line, int col, Object expr) throws BSFException {
        try {
            return this.run(file, line, expr);
        }
        catch (Exception excptn) {
            throw new BSFException(100, "Exception", (Throwable)excptn);
        }
    }

    public void exec(String file, int line, int col, Object expr) throws BSFException {
        try {
            this.run(file, line, expr);
        }
        catch (Exception excptn) {
            throw new BSFException(100, "Exception", (Throwable)excptn);
        }
    }

    public Object call(Object recv, String method, Object[] args) throws BSFException {
        try {
            EmbedRubyObjectAdapter adapter = this.container.newObjectAdapter();
            if (args == null) {
                return adapter.callMethod(recv, method, Object.class);
            }
            return adapter.callMethod(recv, method, args, Object.class);
        }
        catch (Exception excptn) {
            throw new BSFException(100, excptn.getMessage(), (Throwable)excptn);
        }
    }

    public void initialize(BSFManager manager, String language, Vector someDeclaredBeans) throws BSFException {
        super.initialize(manager, language, someDeclaredBeans);
        LocalContextScope scope = SystemPropertyCatcher.getScope(LocalContextScope.THREADSAFE);
        LocalVariableBehavior behavior = LocalVariableBehavior.BSF;
        this.container = new ScriptingContainer(scope, behavior, bsfProps);
        SystemPropertyCatcher.setConfiguration(this.container);
        this.container.getProvider().setLoadPaths(this.getClassPath(manager));
        if (SystemPropertyCatcher.isRuby19(language)) {
            this.container.getProvider().getRubyInstanceConfig().setCompatVersion(CompatVersion.RUBY1_9);
        }
        Ruby runtime = this.container.getRuntime();
        if (someDeclaredBeans != null && someDeclaredBeans.size() > 0) {
            VariableInterceptor interceptor = this.container.getVarMap().getVariableInterceptor();
            for (int i = 0; i < someDeclaredBeans.size(); ++i) {
                BSFDeclaredBean bean = (BSFDeclaredBean)someDeclaredBeans.get(i);
                this.setVariable(interceptor, bean);
            }
        }
        runtime.getGlobalVariables().defineReadonly("$bsf", (IAccessor)new FunctionsGlobalVariable(runtime, new BSFFunctions(manager, (BSFEngine)this)));
    }

    private void setVariable(VariableInterceptor interceptor, BSFDeclaredBean bean) {
        String name = bean.name;
        if ("$bsf".equals(name)) {
            return;
        }
        if (!name.startsWith("$")) {
            name = "$".concat(name);
        }
        BiVariable v = interceptor.getVariableInstance(this.container.getRuntime(), name, bean.bean, bean.type);
        this.container.getVarMap().setVariable(v);
    }

    private List<String> getClassPath(BSFManager manager) {
        String classpath = manager.getClassPath();
        String s = System.getProperty("org.jruby.embed.class.path");
        if (s != null) {
            classpath = classpath + File.pathSeparator + s;
        }
        return Arrays.asList(classpath.split(System.getProperty("path.separator")));
    }

    public void declareBean(BSFDeclaredBean bean) throws BSFException {
        assert (bean != null);
        VariableInterceptor interceptor = this.container.getVarMap().getVariableInterceptor();
        this.setVariable(interceptor, bean);
    }

    public void undeclareBean(BSFDeclaredBean bean) throws BSFException {
        assert (bean != null);
        String name = bean.name;
        if (!name.startsWith("$")) {
            name = "$".concat(name);
        }
        this.container.getVarMap().remove(name);
    }

    public void handleException(BSFException bsfExcptn) {
        JRubyEngine.printException(this.container.getRuntime(), (Exception)bsfExcptn.getTargetException());
    }

    private static void printException(Ruby runtime, Exception exception) {
        assert (exception != null);
        if (exception instanceof RaiseException) {
            JumpException je = (JumpException)exception;
            if (je instanceof RaiseException) {
                runtime.printError(((RaiseException)je).getException());
            } else if (je instanceof JumpException.ThrowJump) {
                runtime.getErrorStream().println("internal error: throw jump caught");
            } else if (je instanceof JumpException.BreakJump) {
                runtime.getErrorStream().println("break without block.");
            } else if (je instanceof JumpException.ReturnJump) {
                runtime.getErrorStream().println("return without block.");
            }
        }
    }

    public void terminate() {
        this.container.getVarMap().clear();
        Ruby runtime = this.container.getRuntime();
        JavaEmbedUtils.terminate((Ruby)runtime);
        runtime = null;
        super.terminate();
    }

    private static class FunctionsGlobalVariable
    implements IAccessor {
        private Ruby runtime;
        private BSFFunctions functions;

        public FunctionsGlobalVariable(Ruby runtime, BSFFunctions functions) {
            this.runtime = runtime;
            this.functions = functions;
        }

        public IRubyObject getValue() {
            IRubyObject result = JavaUtil.convertJavaToRuby((Ruby)this.runtime, (Object)this.functions, BSFFunctions.class);
            return result instanceof JavaObject ? Java.wrap((Ruby)this.runtime, (IRubyObject)result) : result;
        }

        public IRubyObject setValue(IRubyObject value) {
            return value;
        }
    }
}

