/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.internal;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.jruby.RubyInstanceConfig;
import org.jruby.embed.LocalContextProvider;
import org.jruby.embed.LocalVariableBehavior;
import org.jruby.embed.PropertyName;
import org.jruby.embed.internal.LocalContext;
import org.jruby.util.ClassCache;

public abstract class AbstractLocalContextProvider
implements LocalContextProvider {
    protected List loadPaths = null;
    protected ClassCache classCache = null;
    protected RubyInstanceConfig config = new RubyInstanceConfig();
    protected LocalVariableBehavior behavior = LocalVariableBehavior.TRANSIENT;

    public void setLoadPaths(List loadPaths) {
        this.loadPaths = loadPaths;
    }

    public void setClassCache(ClassCache classCache) {
        this.classCache = classCache;
    }

    public RubyInstanceConfig getRubyInstanceConfig() {
        return this.config;
    }

    protected LocalContext getInstance() {
        if (this.loadPaths == null) {
            String paths = System.getProperty(PropertyName.CLASSPATH.toString());
            if (paths == null) {
                paths = System.getProperty("java.class.path");
            }
            this.loadPaths = Arrays.asList(paths.split(File.pathSeparator));
        }
        if (this.config == null) {
            this.config = new RubyInstanceConfig();
            this.config.setCompileMode(RubyInstanceConfig.CompileMode.OFF);
        }
        if (this.classCache != null) {
            this.config.setClassCache(this.classCache);
        }
        return new LocalContext(this.loadPaths, this.config, this.behavior);
    }
}

