/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.jsr223;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.script.Bindings;
import org.jruby.embed.AttributeName;
import org.jruby.embed.ScriptingContainer;

public class JRubyBindings
implements Bindings {
    private ScriptingContainer container;
    public static final String BACKED_BINDING = "org.jruby.embed.jsr223.backed_bindings";

    JRubyBindings(ScriptingContainer container) {
        this.container = container;
        container.getVarMap().clear();
    }

    public int size() {
        Set set = this.entrySet();
        return set.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    private void checkKey(Object key) {
        if (key == null) {
            throw new NullPointerException("key is null");
        }
        if (!(key instanceof String)) {
            throw new ClassCastException("key is NOT String");
        }
        if (((String)key).length() == 0) {
            throw new IllegalArgumentException("key is empty");
        }
    }

    public boolean containsKey(Object key) {
        boolean isExist = this.container.getVarMap().containsKey(key);
        if (!isExist) {
            isExist = this.container.getAttributeMap().containsKey(key);
        }
        return isExist;
    }

    public boolean containsValue(Object value) {
        boolean isExist = this.container.getVarMap().containsValue(value);
        if (!isExist) {
            isExist = this.container.getAttributeMap().containsValue(value);
        }
        return isExist;
    }

    public Object get(Object key) {
        this.checkKey(key);
        Object obj = this.container.get((String)key);
        if (obj == null) {
            obj = this.container.getAttribute(key);
        }
        return obj;
    }

    public Object put(String key, Object value) {
        this.checkKey(key);
        Object oldValue = this.container.put(key, value);
        if (this.container.get(key) == null) {
            oldValue = this.container.setAttribute(key, value);
            if (this.container.getAttributeMap().containsKey(BACKED_BINDING)) {
                Bindings b = (Bindings)this.container.getAttribute(BACKED_BINDING);
                b.put(key, value);
            }
        }
        return oldValue;
    }

    public Object remove(Object key) {
        this.checkKey(key);
        Object removedObj = null;
        if (this.container.getVarMap().containsKey(key)) {
            removedObj = this.container.getVarMap().remove(key);
        } else if (this.container.getAttributeMap().containsKey(key)) {
            removedObj = this.container.getAttributeMap().remove(key);
            if (this.container.getAttributeMap().containsKey(BACKED_BINDING)) {
                Bindings b = (Bindings)this.container.getAttribute(BACKED_BINDING);
                b.remove(key);
            }
        }
        return removedObj;
    }

    public void putAll(Map t) {
        if (t == null) {
            throw new NullPointerException("map is null");
        }
        Set set = t.keySet();
        for (Object key : set) {
            Object value = t.get(key);
            this.put((String)key, value);
        }
    }

    public void clear() {
        this.container.getVarMap().clear();
        Map map = this.container.getAttributeMap();
        if (map == null) {
            return;
        }
        ArrayList eliminateList = new ArrayList();
        for (Object key : map.keySet()) {
            if (!this.isEligibleKey(key)) continue;
            eliminateList.add(key);
        }
        for (Object key : eliminateList) {
            map.remove(key);
        }
    }

    public Set keySet() {
        HashSet keys = new HashSet();
        Set entries = this.entrySet();
        if (entries != null) {
            for (Map.Entry entry : entries) {
                keys.add(entry.getKey());
            }
        }
        keys.addAll(this.container.getVarMap().keySet());
        return keys;
    }

    public Collection values() {
        HashSet values = new HashSet();
        Set entries = this.entrySet();
        if (entries != null) {
            for (Map.Entry entry : entries) {
                values.add(entry.getValue());
            }
        }
        values.addAll(this.container.getVarMap().values());
        return values;
    }

    public Set entrySet() {
        HashSet<Map.Entry> set = new HashSet<Map.Entry>();
        Set s = this.container.getVarMap().entrySet();
        if (s != null) {
            for (Map.Entry entry : s) {
                set.add(entry);
            }
        }
        if ((s = this.container.getAttributeMap().entrySet()) != null) {
            for (Map.Entry entry : s) {
                if (!this.isEligibleKey(entry.getKey())) continue;
                set.add(entry);
            }
        }
        return set;
    }

    private boolean isEligibleKey(Object k) {
        Object[] keys;
        for (Object key : keys = new Object[]{BACKED_BINDING, AttributeName.READER, AttributeName.WRITER, AttributeName.ERROR_WRITER}) {
            if (k != key) continue;
            return false;
        }
        return true;
    }
}

