/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.variable;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.embed.BiVariable;
import org.jruby.embed.internal.BiVariableMap;
import org.jruby.embed.variable.AbstractVariable;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.builtin.IRubyObject;

public class ClassVariable
extends AbstractVariable {
    public static BiVariable getInstance(Ruby runtime, String name, Object ... javaObject) {
        String pattern = "@@([a-zA-Z]|_)([a-zA-Z]|_|\\d)*";
        if (name.matches(pattern)) {
            return new ClassVariable(runtime, name, javaObject);
        }
        return null;
    }

    private ClassVariable(Ruby runtime, String name, Object ... javaObject) {
        super(runtime, name, javaObject);
    }

    ClassVariable(String name, IRubyObject irubyObject) {
        super(name, irubyObject);
    }

    public static void retrieve(Ruby runtime, IRubyObject receiver, BiVariableMap vars) {
        if (receiver == null) {
            receiver = runtime.getTopSelf();
        }
        List names = receiver.getMetaClass().getClassVariableNameList();
        for (String name : names) {
            BiVariable var;
            IRubyObject value = receiver.getMetaClass().getClassVar(name);
            if (vars.containsKey(name)) {
                var = vars.getVariable(name);
                var.setRubyObject(value);
                continue;
            }
            var = new ClassVariable(name, value);
            vars.update(name, var);
        }
    }

    public BiVariable.Type getType() {
        return BiVariable.Type.ClassVariable;
    }

    public void inject(Ruby runtime, IRubyObject receiver) {
        RubyModule rubyClass = this.getRubyClass(runtime);
        rubyClass.setClassVar(this.name, this.irubyObject);
    }

    public void remove(Ruby runtime) {
        RubyModule rubyClass = this.getRubyClass(runtime);
        IRubyObject rubyName = JavaEmbedUtils.javaToRuby((Ruby)runtime, (Object)this.name);
        rubyClass.removeCvar(rubyName);
    }
}

