/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.variable;

import java.util.Set;
import org.jruby.Ruby;
import org.jruby.embed.BiVariable;
import org.jruby.embed.internal.BiVariableMap;
import org.jruby.embed.variable.AbstractVariable;
import org.jruby.internal.runtime.GlobalVariables;
import org.jruby.runtime.builtin.IRubyObject;

public class GlobalVariable
extends AbstractVariable {
    public static BiVariable getInstance(Ruby runtime, String name, Object ... javaObject) {
        String pattern = "\\$([a-zA-Z]|(_([a-zA-Z]|_|\\d)))([a-zA-Z]|_|\\d)*";
        if (name.matches(pattern)) {
            return new GlobalVariable(runtime, name, javaObject);
        }
        return null;
    }

    protected GlobalVariable(Ruby runtime, String name, Object ... javaObject) {
        super(runtime, name, javaObject);
    }

    GlobalVariable(String name, IRubyObject irubyObject) {
        super(name, irubyObject);
    }

    public static void retrieve(Ruby runtime, IRubyObject receiver, BiVariableMap vars) {
        GlobalVariables gvars = runtime.getGlobalVariables();
        Set names = gvars.getNames();
        for (String name : names) {
            BiVariable var;
            if (GlobalVariable.isPredefined(name)) continue;
            IRubyObject value = gvars.get(name);
            if (vars.containsKey(name)) {
                var = vars.getVariable(name);
                var.setRubyObject(value);
                continue;
            }
            var = new GlobalVariable(name, value);
            vars.update(name, var);
        }
    }

    protected static boolean isPredefined(String name) {
        String[] patterns;
        for (String pattern : patterns = new String[]{"\\$([\\u0021-\\u0040]|\\u005c|[\\u005e-\\u0060]|\\u007e)", "\\$-(\\d|[A-z])", "\\$(DEBUG|F|FILENAME|KCODE|LOAD_PATH|SAFE|VERBOSE|CLASSPATH|LOADED_FEATURES|PROGRAM_NAME)", "\\$(configure_args|deferr|defout|expect_verbose|stderr|stdin|stdout)"}) {
            if (!name.matches(pattern)) continue;
            return true;
        }
        return false;
    }

    public BiVariable.Type getType() {
        return BiVariable.Type.GlobalVariable;
    }

    public void inject(Ruby runtime, IRubyObject receiver) {
        runtime.getGlobalVariables().set(this.name, this.irubyObject);
    }

    public void remove(Ruby runtime) {
        this.setJavaObject(runtime, null);
        runtime.getGlobalVariables().set(this.name, this.irubyObject);
    }
}

