/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.structures.attributes;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.gjt.jclasslib.structures.AttributeInfo;
import org.gjt.jclasslib.structures.InvalidByteCodeException;

public class ExceptionsAttribute
extends AttributeInfo {
    public static final String ATTRIBUTE_NAME = "Exceptions";
    private static final int INITIAL_LENGTH = 2;
    private int[] exceptionIndexTable;

    public int[] getExceptionIndexTable() {
        return this.exceptionIndexTable;
    }

    public void setExceptionIndexTable(int[] nArray) {
        this.exceptionIndexTable = nArray;
    }

    public void read(DataInput dataInput) throws InvalidByteCodeException, IOException {
        int n = dataInput.readUnsignedShort();
        this.exceptionIndexTable = new int[n];
        int n2 = 0;
        while (n2 < n) {
            this.exceptionIndexTable[n2] = dataInput.readUnsignedShort();
            ++n2;
        }
        if (this.debug) {
            this.debug("read ");
        }
    }

    public void write(DataOutput dataOutput) throws InvalidByteCodeException, IOException {
        super.write(dataOutput);
        int n = this.getLength(this.exceptionIndexTable);
        dataOutput.writeShort(n);
        int n2 = 0;
        while (n2 < n) {
            dataOutput.writeShort(this.exceptionIndexTable[n2]);
            ++n2;
        }
        if (this.debug) {
            this.debug("wrote ");
        }
    }

    public int getAttributeLength() {
        return 2 + 2 * this.getLength(this.exceptionIndexTable);
    }

    protected void debug(String string) {
        super.debug(string + "Exception attribute with " + this.getLength(this.exceptionIndexTable) + " exceptions");
    }
}

