/*
 * Decompiled with CFR 0.152.
 */
package de.mud.bsx;

import de.mud.bsx.BSXObject;

public class BSXCache {
    protected int cacheSize = 40;
    protected String[] ids = new String[this.cacheSize];
    protected BSXObject[] bsx = new BSXObject[this.cacheSize];
    protected int size = 0;
    protected static final int NOT_FOUND = -1;

    public int size() {
        return this.size;
    }

    public String toString() {
        StringBuffer res = new StringBuffer("" + this.size + " entries\n");
        int i = this.cacheSize - this.size;
        while (i < this.cacheSize) {
            res.append("\t\t" + i + ":\t" + this.ids[i] + "\n");
            ++i;
        }
        return res.toString();
    }

    public BSXObject getEntry(String id) {
        BSXObject res;
        int index = this.find(id);
        if (-1 != index) {
            res = this.bsx[index];
            if (index != this.cacheSize - this.size) {
                this.remove(index);
                ++this.size;
                this.ids[this.cacheSize - this.size] = id;
                this.bsx[this.cacheSize - this.size] = res;
            }
        } else {
            res = null;
        }
        return res;
    }

    public void removeEntry(String id) {
        int index = this.find(id);
        if (-1 != index) {
            BSXObject obj = this.bsx[index];
            obj.flush();
            this.remove(index);
        }
    }

    public void addEntry(String id, BSXObject bsxobject) {
        int index = this.find(id);
        if (-1 != index) {
            this.remove(index);
        } else if (this.size == this.cacheSize) {
            this.move(this.cacheSize / 10);
        }
        ++this.size;
        this.ids[this.cacheSize - this.size] = id;
        this.bsx[this.cacheSize - this.size] = bsxobject;
    }

    public boolean containsEntry(String id) {
        int index = this.find(id);
        return -1 != index;
    }

    private void remove(int index) {
        if (index != this.cacheSize - this.size) {
            int len = index - (this.cacheSize - this.size);
            System.arraycopy(this.ids, this.cacheSize - this.size, this.ids, this.cacheSize - this.size + 1, len);
            System.arraycopy(this.bsx, this.cacheSize - this.size, this.bsx, this.cacheSize - this.size + 1, len);
        } else {
            this.ids[this.cacheSize - this.size] = null;
            this.bsx[this.cacheSize - this.size] = null;
        }
        --this.size;
    }

    private void move(int offset) {
        if (offset > this.size) {
            return;
        }
        int i = 1;
        while (i <= offset) {
            this.bsx[this.cacheSize - i].flush();
            this.bsx[this.cacheSize - i] = null;
            this.ids[this.cacheSize - i] = null;
            ++i;
        }
        System.arraycopy(this.ids, this.cacheSize - this.size, this.ids, this.cacheSize - this.size + offset, this.cacheSize - offset);
        System.arraycopy(this.bsx, this.cacheSize - this.size, this.bsx, this.cacheSize - this.size + offset, this.cacheSize - offset);
        this.size -= offset;
    }

    private int find(String id) {
        int res = -1;
        int index = this.cacheSize - this.size;
        while (index < this.cacheSize) {
            if (id.equals(this.ids[index])) {
                res = index;
                break;
            }
            ++index;
        }
        return res;
    }
}

