/*
 * Decompiled with CFR 0.152.
 */
package de.mud.bsx;

import de.mud.bsx.BSXCache;
import de.mud.bsx.BSXObject;
import de.mud.bsx.BSXScene;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.util.Enumeration;

public final class BSXDisplay
extends Component {
    protected Image picture;
    protected BSXCache scenes = new BSXCache();
    protected BSXCache objects = new BSXCache();
    protected String scene = "<undefined>";
    protected BSXScene bsxscene;
    protected BSXScene working;
    protected boolean sceneChanged = true;
    protected Dimension dim = new Dimension(510, 256);
    protected static final int[][] EMPTY_SCENE = new int[][]{{4, 0, 0, 255, 255, 255, 255, 0, 0, 0}};

    public String showScene(String scene) {
        String res = null;
        this.working = (BSXScene)this.scenes.getEntry(scene);
        if (this.working == null) {
            this.working = new BSXScene(scene, EMPTY_SCENE);
            this.scenes.addEntry(scene, this.working);
            res = "#RQS " + scene + "\n";
            this.scene = scene;
        } else {
            if (!this.scene.equals(scene)) {
                this.scene = scene;
                this.sceneChanged = true;
            }
            this.bsxscene = this.working;
        }
        if (this.bsxscene != null) {
            this.bsxscene.clean();
        }
        return res;
    }

    public void defineScene(String scene, int[][] data) {
        BSXScene _bsxscene;
        if (this.scenes.containsEntry(scene)) {
            _bsxscene = (BSXScene)this.scenes.getEntry(scene);
            _bsxscene.setData(data);
        } else {
            _bsxscene = new BSXScene(scene, data);
            this.scenes.addEntry(scene, _bsxscene);
        }
        if (this.scene.equals(scene)) {
            this.bsxscene = _bsxscene;
            this.working = _bsxscene;
            this.sceneChanged = true;
        }
    }

    public String showObject(String obj, int x, int y) {
        if (this.working != null) {
            if (this.working.containsObject(obj)) {
                this.working.removeObject(obj);
            }
            this.working.addObject(obj, x, y);
            boolean bl = this.sceneChanged = this.working == this.bsxscene;
        }
        if (!this.objects.containsEntry(obj)) {
            return "#RQO " + obj + "\n";
        }
        return null;
    }

    public void removeObject(String obj) {
        if (this.working.containsObject(obj)) {
            this.bsxscene.removeObject(obj);
            this.sceneChanged = this.working == this.bsxscene;
        }
    }

    public void defineObject(String id, int[][] data) {
        if (this.objects.containsEntry(id)) {
            BSXObject r = this.objects.getEntry(id);
            r.setData(data);
        } else {
            this.objects.addEntry(id, new BSXObject(id, data));
        }
        this.sceneChanged = this.bsxscene != null && this.bsxscene.containsObject(id);
    }

    public void refreshScene() {
        if (this.sceneChanged) {
            this.sceneChanged = false;
            this.redraw();
            this.repaint();
        }
    }

    private void redraw() {
        if (this.bsxscene == null) {
            return;
        }
        Graphics g = this.picture.getGraphics();
        this.bsxscene.fill(g);
        int layer = 7;
        while (layer >= 0) {
            Enumeration ob_enum = this.bsxscene.objects(layer);
            while (ob_enum.hasMoreElements()) {
                String id = (String)ob_enum.nextElement();
                Point pos = this.bsxscene.locateObject(id);
                if (!this.objects.containsEntry(id)) continue;
                BSXObject obj = this.objects.getEntry(id);
                obj.draw(g, pos.x, pos.y);
            }
            --layer;
        }
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        g.drawImage(this.picture, 0, 0, null);
    }

    public void addNotify() {
        super.addNotify();
        this.picture = this.newImage();
    }

    private Image newImage() {
        return this.createImage(this.dim.width, this.dim.height);
    }

    public void removeNotify() {
        this.picture.flush();
    }

    public Dimension getPreferredSize() {
        return this.dim;
    }

    public Dimension getMinimumSize() {
        return this.dim;
    }

    public static void main(String[] args) {
        Frame f = new Frame("BSXDisplay Test");
        BSXDisplay b = new BSXDisplay();
        f.add(b);
        f.pack();
        f.setResizable(false);
        f.show();
        int[][] scene = new int[][]{{0, 0, 0, 255, 0, 255, 255, 0, 255}, {4, 127, 127, 255, 255, 0, 255}, {8, 120, 120, 134, 120, 134, 134, 120, 134}};
        b.defineScene("int/picture", scene);
        b.showScene("int/picture");
        b.refreshScene();
        int[][] bsx = new int[][]{{2, 40, 0, 215, 0, 255, 127, 0, 127}};
        b.defineObject("rahmen", bsx);
        b.showObject("rahmen", 7, 7);
        b.refreshScene();
    }
}

