/*
 * Decompiled with CFR 0.152.
 */
package de.mud.jta.plugin;

import de.mud.bsx.BSXDisplay;
import de.mud.jta.FilterPlugin;
import de.mud.jta.Plugin;
import de.mud.jta.PluginBus;
import de.mud.jta.VisualPlugin;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Menu;
import java.awt.Panel;
import java.io.IOException;

public class BSX
extends Plugin
implements FilterPlugin,
VisualPlugin {
    protected BSXDisplay visual = new BSXDisplay();
    protected Panel panel = new Panel(new FlowLayout(1));
    private static final byte[] RFS = "@RFS".getBytes();
    private static final byte[] SCE = "@SCE".getBytes();
    private static final byte[] VIO = "@VIO".getBytes();
    private static final byte[] DFS = "@DFS".getBytes();
    private static final byte[] DFO = "@DFO".getBytes();
    private static final byte[] RMO = "@RMO".getBytes();
    private static final byte[] TMS = "@TMS".getBytes();
    private static final byte[] RQV = "@RQV".getBytes();
    protected static String VERSION = "Java 1.0";
    protected boolean ignoreErrors = true;
    FilterPlugin source;
    private byte[] cmd = new byte[4];
    private int cmdlen = 0;
    private byte[] id = new byte[64];
    private int idlen = 0;
    private String obj = null;
    private int[][] data = null;
    private byte[] hex = new byte[2];
    private int hexlen = 0;
    private byte[] res = new byte[4096];
    private int polys = 0;
    private int edges = 0;
    private int poly = 0;
    private int pos = 0;
    private int xpos = 0;
    private int ypos = 0;
    private int state = 0;

    public BSX(PluginBus bus, String id) {
        super(bus, id);
        this.panel.add(this.visual);
        this.reset();
    }

    public Component getPluginVisual() {
        return this.panel;
    }

    public Menu getPluginMenu() {
        return null;
    }

    public void setFilterSource(FilterPlugin source) {
        this.source = source;
    }

    public int read(byte[] b) throws IOException {
        int len = this.source.read(b);
        len = this.parse(b, len);
        return len;
    }

    public void write(byte[] b) throws IOException {
        this.source.write(b);
    }

    private void write(String s) throws IOException {
        this.write(s.getBytes());
    }

    protected void reset() {
        this.hexlen = 0;
        this.idlen = 0;
        this.cmdlen = 0;
        this.data = null;
        this.obj = null;
        this.state = 0;
        this.ypos = 0;
        this.xpos = 0;
        this.pos = 0;
        this.poly = 0;
        this.edges = 0;
        this.polys = 0;
    }

    private void DBG(String arg) {
        System.err.println("BSX:\t" + arg);
    }

    protected int parse(byte[] b, int length) throws IOException {
        int resindex = 0;
        int index = 0;
        while (index < length) {
            switch (this.state) {
                case 0: {
                    if ((char)b[index] == '@') {
                        this.cmd[this.cmdlen++] = b[index];
                        this.state = 1;
                        break;
                    }
                    this.res[resindex++] = b[index];
                    break;
                }
                case 1: {
                    int i;
                    if ((char)b[index] == '@') {
                        int i2 = 0;
                        while (i2 < this.cmdlen) {
                            this.res[resindex++] = this.cmd[i2];
                            ++i2;
                        }
                        this.cmdlen = 0;
                        this.cmd[this.cmdlen++] = b[index];
                        break;
                    }
                    this.cmd[this.cmdlen++] = b[index];
                    if (this.cmdlen != 4) break;
                    if (this.equals(this.cmd, RFS)) {
                        this.visual.refreshScene();
                        this.reset();
                        break;
                    }
                    if (this.equals(this.cmd, RQV)) {
                        this.write("#VER " + VERSION + "\n");
                        this.reset();
                        break;
                    }
                    if (this.equals(this.cmd, SCE)) {
                        this.state = 2;
                        break;
                    }
                    if (this.equals(this.cmd, VIO)) {
                        this.state = 2;
                        break;
                    }
                    if (this.equals(this.cmd, DFO)) {
                        this.state = 2;
                        break;
                    }
                    if (this.equals(this.cmd, RMO)) {
                        this.state = 2;
                        break;
                    }
                    if (this.equals(this.cmd, DFS)) {
                        this.state = 2;
                        break;
                    }
                    if (this.equals(this.cmd, TMS)) {
                        byte[] temp = "\n\n\tTerminate Session!\n\n".getBytes();
                        i = 0;
                        while (i < temp.length) {
                            this.res[resindex++] = temp[i];
                            ++i;
                        }
                        this.reset();
                        break;
                    }
                    int i3 = 0;
                    while (i3 < this.cmdlen) {
                        this.res[resindex++] = this.cmd[i3];
                        ++i3;
                    }
                    this.reset();
                    break;
                }
                case 2: {
                    int i;
                    if ((char)b[index] == '@') {
                        int i4 = 0;
                        while (i4 < this.cmdlen) {
                            this.res[resindex++] = this.cmd[i4];
                            ++i4;
                        }
                        i = 0;
                        while (i < this.idlen) {
                            this.res[resindex++] = this.id[i];
                            ++i;
                        }
                        this.cmdlen = 0;
                        this.cmd[this.cmdlen++] = b[index];
                        this.idlen = 0;
                        this.state = 1;
                        break;
                    }
                    if ((char)b[index] != '.') {
                        this.id[this.idlen++] = b[index];
                        break;
                    }
                    this.obj = new String(this.id, 0, this.idlen);
                    if (this.equals(this.cmd, SCE)) {
                        String query = this.visual.showScene(this.obj);
                        if (query != null) {
                            this.write(query);
                        }
                        this.reset();
                        break;
                    }
                    if (this.equals(this.cmd, VIO)) {
                        this.state = 6;
                        break;
                    }
                    if (this.equals(this.cmd, RMO)) {
                        this.visual.removeObject(this.obj);
                        this.reset();
                        break;
                    }
                    if (this.equals(this.cmd, DFS)) {
                        this.state = 3;
                        break;
                    }
                    if (!this.equals(this.cmd, DFO)) break;
                    this.state = 3;
                    break;
                }
                case 3: {
                    this.hex[this.hexlen++] = b[index];
                    if (this.hexlen != 2) break;
                    this.polys = this.hexToInt(this.hex);
                    if (this.polys > 32 || this.polys < 0) {
                        this.DBG("polys " + this.polys + "\t" + this.obj);
                        if (this.ignoreErrors) {
                            this.DBG("ignoring till @RFS");
                            this.cmdlen = 0;
                            this.state = 8;
                            break;
                        }
                        this.reset();
                        break;
                    }
                    this.data = new int[this.polys][];
                    if (this.polys > 0) {
                        this.state = 4;
                    } else {
                        if (this.equals(this.cmd, DFS)) {
                            this.visual.defineScene(this.obj, this.data);
                        } else if (this.equals(this.cmd, DFO)) {
                            this.visual.defineObject(this.obj, this.data);
                        }
                        this.reset();
                    }
                    this.hexlen = 0;
                    break;
                }
                case 4: {
                    this.hex[this.hexlen++] = b[index];
                    if (this.hexlen != 2) break;
                    this.edges = this.hexToInt(this.hex);
                    if (this.edges > 32 || this.edges < 0) {
                        this.DBG("edges " + this.edges + "\t" + this.obj);
                        if (this.ignoreErrors) {
                            this.DBG("\tignoring till @RFS");
                            this.cmdlen = 0;
                            this.state = 8;
                            break;
                        }
                        this.reset();
                        break;
                    }
                    this.data[this.poly] = new int[1 + this.edges * 2];
                    this.state = 5;
                    this.hexlen = 0;
                    break;
                }
                case 5: {
                    this.hex[this.hexlen++] = b[index];
                    if (this.hexlen != 2) break;
                    int c = this.hexToInt(this.hex);
                    if (c < 0) {
                        this.DBG("edge " + c + "\t" + this.obj);
                        if (this.ignoreErrors) {
                            this.DBG("\tignoring till @RFS");
                            this.cmdlen = 0;
                            this.state = 8;
                            break;
                        }
                        this.reset();
                        break;
                    }
                    this.data[this.poly][this.pos] = c;
                    this.hexlen = 0;
                    ++this.pos;
                    if (this.pos != this.edges * 2 + 1) break;
                    ++this.poly;
                    this.state = 4;
                    this.pos = 0;
                    if (this.poly != this.polys) break;
                    if (this.equals(this.cmd, DFS)) {
                        this.visual.defineScene(this.obj, this.data);
                    } else if (this.equals(this.cmd, DFO)) {
                        this.visual.defineObject(this.obj, this.data);
                    }
                    this.reset();
                    break;
                }
                case 6: {
                    this.hex[this.hexlen++] = b[index];
                    if (this.hexlen != 2) break;
                    this.xpos = this.hexToInt(this.hex);
                    if (this.xpos > 15 || this.xpos < 0) {
                        this.DBG("xpos " + this.xpos + "\t" + this.obj);
                        this.reset();
                        break;
                    }
                    this.state = 7;
                    this.hexlen = 0;
                    break;
                }
                case 7: {
                    this.hex[this.hexlen++] = b[index];
                    if (this.hexlen != 2) break;
                    this.ypos = this.hexToInt(this.hex);
                    if (this.ypos > 7 || this.ypos < 0) {
                        this.DBG("ypos " + this.ypos + "\t" + this.obj);
                        this.reset();
                        break;
                    }
                    String query = this.visual.showObject(this.obj, this.xpos, this.ypos);
                    if (query != null) {
                        this.write(query);
                    }
                    this.reset();
                    break;
                }
                case 8: {
                    if ((char)b[index] == '@') {
                        this.cmdlen = 0;
                        this.cmd[this.cmdlen++] = b[index];
                        break;
                    }
                    if (this.cmdlen <= 0) break;
                    this.cmd[this.cmdlen++] = b[index];
                    if (this.cmdlen != 4) break;
                    if (this.equals(this.cmd, RFS)) {
                        this.visual.refreshScene();
                        this.reset();
                        break;
                    }
                    this.cmdlen = 0;
                }
            }
            ++index;
        }
        System.arraycopy(this.res, 0, b, 0, resindex);
        return resindex;
    }

    protected boolean equals(byte[] a, byte[] b) {
        int i = 0;
        while (i < a.length && i < b.length) {
            if (a[i] != b[i]) {
                return false;
            }
            ++i;
        }
        return a.length == b.length;
    }

    protected int hexToInt(byte[] b) {
        int f = 0;
        int g = 0;
        char h = '\u0000';
        char i = '\u0000';
        h = (char)b[0];
        i = (char)b[1];
        if (h >= 'A' && h <= 'F') {
            f = h - 65 + 10;
        } else if (h >= '0' && h <= '9') {
            f = h - 48;
        } else {
            return -1;
        }
        if (i >= 'A' && i <= 'F') {
            g = i - 65 + 10;
        } else if (i >= '0' && i <= '9') {
            g = i - 48;
        } else {
            return -1;
        }
        return f * 16 + g;
    }
}

