/*
 * Decompiled with CFR 0.152.
 */
package de.mud.jta.plugin;

import de.mud.jta.FilterPlugin;
import de.mud.jta.Plugin;
import de.mud.jta.PluginBus;
import de.mud.jta.PluginConfig;
import de.mud.jta.PluginListener;
import de.mud.jta.event.ConfigurationListener;
import de.mud.jta.event.EndOfRecordListener;
import gnu.regexp.RE;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class MUDColorizer
extends Plugin
implements FilterPlugin,
EndOfRecordListener,
ConfigurationListener {
    public static String BLACK = "\u001b[30m";
    public static String RED = "\u001b[31m";
    public static String BRED = "\u001b[1;31m";
    public static String GREEN = "\u001b[32m";
    public static String BGREEN = "\u001b[1;32m";
    public static String YELLOW = "\u001b[33m";
    public static String BYELLOW = "\u001b[1;33m";
    public static String BLUE = "\u001b[34m";
    public static String BBLUE = "\u001b[1;34m";
    public static String PINK = "\u001b[35m";
    public static String BPINK = "\u001b[1;35m";
    public static String CYAN = "\u001b[36m";
    public static String BCYAN = "\u001b[1;36m";
    public static String WHITE = "\u001b[37m";
    public static String BWHITE = "\u001b[1;37m";
    public static String NORMAL = "\u001b[0m";
    public static String BOLD = "\u001b[1m";
    private Object[] exps = null;
    FilterPlugin source;
    private int lp = 0;
    private byte[] line = new byte[8192];
    private boolean readprompt = false;
    private boolean promptread = false;
    private boolean writeprompt = false;
    private boolean promptwritten = false;
    private byte[] prompt = null;
    private byte[] buffer = null;
    private int pos = 0;

    public MUDColorizer(PluginBus bus, String id) {
        super(bus, id);
        bus.registerPluginListener((PluginListener)this);
    }

    public void setConfiguration(PluginConfig cfg) {
        String tmp = cfg.getProperty("MUDColorizer", this.id, "regexpSet");
        if (tmp != null) {
            Properties regexpSet = new Properties();
            try {
                regexpSet.load(((Object)((Object)this)).getClass().getResourceAsStream(tmp));
            }
            catch (Exception e) {
                try {
                    regexpSet.load(new URL(tmp).openStream());
                }
                catch (Exception ue) {
                    this.error("cannot find regexpSet: " + tmp);
                    this.error("resource access failed: " + e);
                    this.error("URL access failed: " + ue);
                    regexpSet = null;
                }
            }
            if (regexpSet != null && !((Hashtable)regexpSet).isEmpty()) {
                this.exps = new Object[((Hashtable)regexpSet).size() * 2];
                Hashtable<String, String> colors = new Hashtable<String, String>();
                colors.put("BLACK", BLACK);
                colors.put("RED", RED);
                colors.put("BRED", BRED);
                colors.put("GREEN", GREEN);
                colors.put("BGREEN", BGREEN);
                colors.put("YELLOW", YELLOW);
                colors.put("BYELLOW", BYELLOW);
                colors.put("BLUE", BLUE);
                colors.put("BBLUE", BBLUE);
                colors.put("PINK", PINK);
                colors.put("BPINK", BPINK);
                colors.put("CYAN", CYAN);
                colors.put("BCYAN", BCYAN);
                colors.put("WHITE", WHITE);
                colors.put("BWHITE", BWHITE);
                colors.put("NORMAL", NORMAL);
                colors.put("BOLD", BOLD);
                Enumeration<?> names = regexpSet.propertyNames();
                int ex = 0;
                while (names.hasMoreElements()) {
                    String exp = (String)names.nextElement();
                    RE re = null;
                    try {
                        re = new RE((Object)exp);
                    }
                    catch (Exception e) {
                        System.err.println("Something wrong with regexp: " + ex + "\t" + exp);
                        System.err.println(e);
                    }
                    this.exps[ex++] = re;
                    this.exps[ex++] = colors.get(((Hashtable)regexpSet).get(exp));
                    System.out.println("MUDColorizer: loaded: " + exp + " with " + ((Hashtable)regexpSet).get(exp));
                }
            }
        }
    }

    public void setFilterSource(FilterPlugin source) {
        this.source = source;
    }

    public void EndOfRecord() {
        this.readprompt = true;
    }

    private byte[] transpose(byte[] buf) {
        int nbufptr = 0;
        byte[] nbuf = new byte[8192];
        if (this.promptwritten && this.prompt != null && this.prompt.length > 0) {
            nbuf[nbufptr++] = 13;
            nbuf[nbufptr++] = 27;
            nbuf[nbufptr++] = 91;
            nbuf[nbufptr++] = 75;
            this.promptwritten = false;
        }
        if (this.readprompt) {
            int index = buf.length - 1;
            while (index >= 0) {
                if (buf[index] == 10) break;
                --index;
            }
            this.prompt = new byte[buf.length - ++index];
            System.arraycopy(buf, index, this.prompt, 0, buf.length - index);
            this.readprompt = false;
            this.writeprompt = true;
            this.promptwritten = false;
            this.promptread = true;
        }
        if (this.promptwritten) {
            this.lp = 0;
            this.line[0] = 0;
        }
        int i = 0;
        while (i < buf.length) {
            this.line[this.lp] = buf[i];
            if (this.line[this.lp] == 10) {
                String l = new String(this.line, 0, this.lp + 1);
                boolean colored = false;
                boolean useexp = this.exps != null;
                int ex = 0;
                while (!colored && useexp && ex < this.exps.length) {
                    RE exp = (RE)this.exps[ex];
                    if (null != exp.getMatch((Object)l)) {
                        byte[] color = ((String)this.exps[ex + 1]).getBytes();
                        System.arraycopy(color, 0, nbuf, nbufptr, color.length);
                        System.arraycopy(this.line, 0, nbuf, nbufptr += color.length, this.lp + 1);
                        byte[] normal = NORMAL.getBytes();
                        System.arraycopy(normal, 0, nbuf, nbufptr += this.lp + 1, normal.length);
                        nbufptr += normal.length;
                        colored = true;
                    }
                    ex += 2;
                }
                if (!colored) {
                    System.arraycopy(this.line, 0, nbuf, nbufptr, this.lp + 1);
                    nbufptr += this.lp + 1;
                }
                colored = false;
                this.lp = -1;
                this.line[0] = 0;
            }
            ++i;
            ++this.lp;
        }
        if (this.promptread) {
            this.lp = 0;
            this.line[0] = 0;
            this.promptread = false;
        }
        if (buf[buf.length - 1] == 10) {
            this.writeprompt = true;
        }
        if (buf[buf.length - 1] == 13) {
            this.writeprompt = true;
        }
        if (this.writeprompt && this.prompt != null && this.prompt.length > 0) {
            nbuf[nbufptr++] = 13;
            nbuf[nbufptr++] = 27;
            nbuf[nbufptr++] = 91;
            nbuf[nbufptr++] = 75;
            System.arraycopy(this.prompt, 0, nbuf, nbufptr, this.prompt.length);
            nbufptr += this.prompt.length;
            this.promptwritten = true;
            this.writeprompt = false;
        }
        byte[] xbuf = new byte[nbufptr];
        System.arraycopy(nbuf, 0, xbuf, 0, nbufptr);
        return xbuf;
    }

    public int read(byte[] b) throws IOException {
        if (this.buffer != null) {
            int amount = this.buffer.length - this.pos <= b.length ? this.buffer.length - this.pos : b.length;
            System.arraycopy(this.buffer, this.pos, b, 0, amount);
            if (this.pos + amount < this.buffer.length) {
                this.pos += amount;
            } else {
                this.buffer = null;
                this.pos = 0;
            }
            return amount;
        }
        int n = this.source.read(b);
        if (n > 0) {
            byte[] tmp = new byte[n];
            System.arraycopy(b, 0, tmp, 0, n);
            this.buffer = this.transpose(tmp);
            if (this.buffer != null && this.buffer.length > 0) {
                int amount = this.buffer.length <= b.length ? this.buffer.length : b.length;
                System.arraycopy(this.buffer, 0, b, 0, amount);
                this.pos = n = amount;
                if (amount == this.buffer.length) {
                    this.buffer = null;
                    this.pos = 0;
                }
            } else {
                return 0;
            }
        }
        return n;
    }

    public void write(byte[] b) throws IOException {
        if (b[b.length - 1] == 10) {
            this.writeprompt = true;
            this.promptwritten = false;
        }
        this.source.write(b);
    }
}

