/***************************************************************************
                          errorscreen.cpp  -  description
                             -------------------
    begin                : Fri Feb 22 2002
    copyright            : (C) 2002 by Sebastian Schildt
    email                : sebastian@frozenlight.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "errorscreen.h"

void ErrorScreen::paintScreen(QPainter *p,  QString msg, paintHelpers *ph) {

  ph->clearScreen(p);

	ph->drawMainHeader(p,"Subroutine failure",Qt::red);
 	p->setPen(Qt::red);

	ph->sound->playErr();

	QFontMetrics Metrics2(ph->mediumFont);
	p->setFont(ph->headerfont);
	QFontMetrics Metrics1=p->fontMetrics();
	
	
	int width1 = Metrics1.width("Fatal error during database query");
	int width2 = Metrics2.width(msg);
	
	p->drawText( (1024-width1)/2, (768-2*Metrics1.ascent())/2, "Fatal error during database query" );

	p->setFont(ph->mediumFont);
	for (int i = 0; i < 5; i++) {
		p->fillRect(0, ((768-Metrics1.ascent())/2)-Metrics2.ascent(),1024,Metrics2.ascent()+Metrics2.descent(),Qt::black);	
		p->flush();
		usleep(800000);
		p->drawText( (1024-width2)/2, (768-Metrics2.ascent())/2, msg );
		p->flush();
		usleep(800000);
 }

}
