/***************************************************************************
                          gaussianscreen.cpp  -  description
                             -------------------
    begin                : Fri Jan 25 2002
    copyright            : (C) 2002 by Sebastian Schildt
    email                : sebastian@frozenlight.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "gaussianscreen.h"

void GaussianScreen::paintScreen(QPainter *p, QWidget *rpt, setiparse *s, paintHelpers *ph) {
  ph->clearScreen(p);
	ph->drawMainHeader(p,"Signal detected: Gaussian");


	gau = s->getGaussian();
	graph = plotGaussian(gau);
	p->drawPixmap(10,85,graph);
	p->flush();
	
	QString qtmp;
	usleep(800000);
	p->setFont(ph->mediumFont);
	p->setPen(ph->lcarsLila);
	p->drawText(360,120,"Displaying signal characteristics");
	ph->sound->playBeep1();
	p->flush();

	p->setPen(ph->lcarsOrange);
	usleep(800000);
	qtmp.sprintf("Detected with a chirprate of %.3f Hz",gau.chirpRate);
	ph->sound->playBeep2();
	p->drawText(360,150,qtmp);
	p->flush();

	usleep(400000);
	qtmp.sprintf("Signal strength: %.3f",gau.power);
	ph->sound->playBeep2();
	p->drawText(360,175,qtmp);
	p->flush();

	usleep(400000);
	qtmp.sprintf("Signal quality: %.3f",gau.chiSquare);
	ph->sound->playBeep2();
	p->drawText(360,200,qtmp);
	p->flush();

  usleep(400000);
	qtmp.sprintf("Signal length: %d",gau.fftLen);
	ph->sound->playBeep2();
	p->drawText(360,225,qtmp);
	p->flush();

	usleep(400000);
	qtmp = "Data segment ";
	qtmp = qtmp + s->getWu_name().c_str();
	qtmp = qtmp + " will be saved for further analysis.";
	ph->sound->playBeep2();
	p->drawText(10,340,qtmp);
	p->flush();

	
	usleep(800000);
	p->setFont(ph->headerfont);
	QFontMetrics fm(ph->headerfont);
	//qtmp.sprintf("Signal artificial with a probability of %.3f %%",gau.score);
	qtmp.sprintf("Signal quality index is %.3f",gau.score);
	int border = (1024- fm.width(qtmp))/2;
	ph->sound->playBeep2();
	p->drawText(border,650,qtmp,23);
	qtmp.sprintf("%.3f",gau.score);
	int fromLeft = 1024-(border+fm.width(qtmp));
	for (int i = 0; i <= 12; i++) {
		if (i % 2 == 0) {
			p->setPen(ph->lcarsOrange);
			p->drawText( fromLeft,650,qtmp );
		}
		else {
			p->setPen(Qt::black);
			p->fillRect(fromLeft,600,1024-fromLeft,100,Qt::black);
		}
		p->flush();
		usleep(800000);
	}
	
	//sleep(7);
}


QPixmap GaussianScreen::plotGaussian(Gaussian g) {
     QPixmap tmp(320,200);
		tmp.fill(Qt::black);

		double max = 0;
		for (int i = 0; i < 64; i++) {
     	if (g.data[i] > max) { max = g.data[i]; }
		}
		//cout << "Max is " << max << endl;
		QColor redcol(255,0,0);
		QPainter p(&tmp);

		double factor = 200 / max;
		int prevHeight = (int) (gau.data[0] * factor);
		int height;
		p.setPen(QPen(redcol));
		//cout << "Draw gaussian" << endl;
		for (int i = 0; i <= 63; i++) {
   		height = (int) (gau.data[i]*factor);
			p.drawLine(i*5,199-prevHeight,i*5,199-height);
			p.drawLine(i*5,199-height,(i*5)+5,199-height);
			prevHeight=height;
	  }

	/*Draw real gaussian
	Again this is mostly stolen from KSetiwatch ;-)
 	g(x) = a + b*exp(-(x - c)/d),

	wobei a, b, c, und d konstante Parameter sind. Auf SETI@home bertragen
	mssen wir folgendes einsetzen:

	a = bg_true_mean
	b = bg_power
	c = bg_fft_ind
	d = bg_sigma
	*/
		int accuracy =128;
	 	double y[accuracy];
		double r = accuracy/64;
		for (int i = 0; i <= accuracy; i++) {
			y[i] = g.trueMean + g.power*exp(-((i/r)-g.fftInd)*((i/r)-g.fftInd)/(g.sigma*g.sigma));
			y[i]=y[i]*factor;
		}

		p.setPen(Qt::white);
		p.moveTo(0,(int)(200-y[0]));
		double step = 320.0 / accuracy;
		//cout << "step is " << step <<endl;
		for (int i = 0; i <= accuracy; i++) {
     	 p.lineTo((int)(i*step),200-(int)(y[i]));
		}

		return tmp;
}
