/***************************************************************************
                          ksetiwatchimporter.cpp  -  description
                             -------------------
    begin                : Sun Mar 24 2002
    copyright            : (C) 2002 by Sebastian Schildt
    email                : sebastian@frozenlight.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "ksetiwatchimporter.h"

//#include <iostream>

QStringList KSetiwatchImporter::readKswConfig() {
	QStringList dirs;

	KSimpleConfig kswc("ksetiwatchrc",true);
	if (!kswc.hasGroup("Seti Locations")) {
		res = PARSE_ERROR;
    return NULL;
	}

	kswc.setGroup("Seti Locations");
	int num = kswc.readNumEntry("count",-1);
	if (num < 1) {
		res = PARSE_ERROR;
    return NULL;
	}

	QString stmp, key;
  for (int i = 1; i <= num; i++) {
			key.sprintf("Directory_%i",i);
  	  stmp = kswc.readEntry(key);

			//cout << "Slash at " <<  stmp.findRev("/",-1) << " Length is " << stmp.length() << endl;
      if ( !( stmp.findRev("/",-1) == stmp.length()-1 ) ) {
      	stmp=stmp+"/";
				//cout << "FIX ";
			}
			//cout << stmp.latin1() << endl;
			if (stmp != stmp.null) {
       	dirs << stmp;
			}
	}

	if(dirs.isEmpty()) {
  	res = PARSE_ERROR;
    return NULL;
	}
  res = OK;
	//res = PARSE_ERROR; //for debug...
	return dirs;
}

