/*
    KSocrat
    Version 3.2.1, 17 July 2004
    (C) 2000-2004 Zavolzhsky Alexandr <zavolzhsky@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  
*/

#include <kapp.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <kconfig.h>
#include "ksocrat.h"
 
int main(int argc, char *argv[])
{  
  KAboutData *aboutData = new KAboutData("ksocrat",
             "KSocrat","3.2.1",
             "KSocrat", KAboutData::License_GPL,
             "(C) 2000-2004 Zavolzhsky Alexandr",
             "English/Russian and Russian/English dictionary",
             "http://ksocrat.linux.kiev.ua");
             
  aboutData->addAuthor("Zavolzhsky Alexandr",
             "Developer/Maintainer",
             "zavolzhsky@mail.ru",
             "http://ksocrat.linux.kiev.ua");
             
  aboutData->addCredit("Arsenal Company","Dictionary bases are provided by Arsenal Company for KSocrat only.");
  aboutData->addCredit("Dictionary bases (C) 1996 Arsenal Company", "", "", "http://www.arssoft.com.");

  aboutData->addCredit("Dmitry Vukolov",
             "Fixes and improvements",
             "dav@altlinux.ru");

  aboutData->addCredit("Sergey V Turchin",
             "Russian translation",
             "zerg@altlinux.ru");

  KCmdLineArgs::init(argc, argv, aboutData);
  KApplication a;

  KConfig *config = kapp->config();
  config->setGroup("General");
  bool bHideOnStartUp = config->readBoolEntry("HideOnStartUp",false);
  
  KSocrat *ksocrat = new KSocrat();
  a.setMainWidget(ksocrat);
  ksocrat->setPlainCaption("KSocrat");

  if(!bHideOnStartUp) {
    ksocrat->show();  
  }  

  return a.exec();
}
