/***************************************************************************
 *   Copyright (C) 2005 by Nguyen The Toan   *
 *   nguyenthetoan@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "dirselectiondialog.h"

#include <kdebug.h>
#include <klocale.h>
#include <qlistbox.h>
#include <qpushbutton.h>
#include <qlineedit.h>
#include <qfiledialog.h>
#include <qlayout.h>
#include <qcheckbox.h>
#include <qradiobutton.h>
#include <qbuttongroup.h>

//extern "C" {
#include "xmame_executable.h"
#include "gxmame.h"
//}

dirSelectionDialog::dirSelectionDialog(QWidget *parent, const char *name)
    :dirSelectionTab(parent, name)
{
	XmameExecutable *exec;
	int i, cur_exec = -1;
	QStringList execs,roms,samples;
	
	for (i = 0; ; i++) {
		exec = xmame_table_get_by_index (i);
		if (!exec) break;
		execs << exec->path;
		if (exec == current_exec) {
			cur_exec = i;
		}
	}
	execList->clear();
	execList->insertStringList(execs);
	if(cur_exec >= 0)
		execList->setCurrentItem(cur_exec);
	
	for (i = 0; gui_prefs.RomPath[i] != NULL; i++) {
		roms << gui_prefs.RomPath[i];
	}
	romList->clear();
	romList->insertStringList(roms);
	
	for (i = 0; gui_prefs.SamplePath[i] != NULL; i++) {
		samples << gui_prefs.SamplePath[i];
	}
	sampleList->clear();
	sampleList->insertStringList(samples);

	
	catverEdit->setText(gui_prefs.catverDirectory);
	flyerEdit->setText(gui_prefs.FlyerDirectory);
	cabinetEdit->setText(gui_prefs.CabinetDirectory);
	marqueeEdit->setText(gui_prefs.MarqueeDirectory);
	snapEdit->setText(gui_prefs.TitleDirectory);
	iconEdit->setText(gui_prefs.IconDirectory);
	artEdit->setText(gui_prefs.mameArtworkDirectory);
	messArtEdit->setText(gui_prefs.messArtworkDirectory);
	snapShotEdit->setText(gui_prefs.SnapshotDirectory);
	videoEdit->setText(gui_prefs.VideoDirectory);
	historyEdit->setText(gui_prefs.HistoryFile);
	mameInfoEdit->setText(gui_prefs.MameInfoFile);
	cheatEdit->setText(gui_prefs.mameCheatFile);
	messCheatEdit->setText(gui_prefs.messCheatFile);
	highscoreEdit->setText(gui_prefs.HiscoreFile);
	controllerEdit->setText(gui_prefs.CtrlrDirectory);
	/* User resources */
	messRadioOff = TRUE;
	highscorePathEdit->setText(gui_prefs.mameHiscoreDirectory);
	mHighScore=QString(gui_prefs.messHiscoreDirectory);
	recordEdit->setText(gui_prefs.mameInputDirectory);
	mRecord=QString(gui_prefs.messInputDirectory);
	gameConfigEdit->setText(gui_prefs.mameConfigDirectory);
	mConfig=QString(gui_prefs.messConfigDirectory);
	nvramEdit->setText(gui_prefs.mameNVRamDirectory);
	mNvram=QString(gui_prefs.messNVRamDirectory);
	memoryEdit->setText(gui_prefs.mameMemCardDirectory);
	mMemory=QString(gui_prefs.messMemCardDirectory);
	iniEdit->setText(gui_prefs.mameInipath);
	mIni=QString(gui_prefs.messInipath);
	gameStatusEdit->setText(gui_prefs.mameStateDirectory);
	mStatus=QString(gui_prefs.messStateDirectory);
	diffEdit->setText(gui_prefs.mameDiffDirectory);
	mDiff=QString(gui_prefs.messDiffDirectory);
	/* mess specific */
	messSysinfoPathEdit->setText(gui_prefs.sysinfoFile);
	messBiosPathEdit->setText(gui_prefs.messBiosDirectory);
	messSnapPathEdit->setText(gui_prefs.messSnapDirectory);
	alternativeEdit->setText(gui_prefs.AlternativeFile);
	connect (execBrowse, SIGNAL(clicked()), this, SLOT(on_execBrowse()));
	connect (catverBrowse, SIGNAL(clicked()), this, SLOT(on_catverBrowse()));
	connect (flyerBrowse, SIGNAL(clicked()), this, SLOT(on_flyerBrowse()));
	connect (cabinetBrowse, SIGNAL(clicked()), this, SLOT(on_cabinetBrowse()));
	connect (marqueeBrowse, SIGNAL(clicked()), this, SLOT(on_marqueeBrowse()));
	connect (snapBrowse, SIGNAL(clicked()), this, SLOT(on_snapBrowse()));
	connect (videoBrowse, SIGNAL(clicked()), this, SLOT(on_videoBrowse()));
	connect (iconBrowse, SIGNAL(clicked()), this, SLOT(on_iconBrowse()));
	connect (romBrowse, SIGNAL(clicked()), this, SLOT(on_romBrowse()));
	connect (sampleBrowse, SIGNAL(clicked()), this, SLOT(on_sampleBrowse()));
	connect (artBrowse, SIGNAL(clicked()), this, SLOT(on_artBrowse()));
	connect (messArtBrowse, SIGNAL(clicked()), this, SLOT(on_messArtBrowse()));
	connect (snapShotBrowse, SIGNAL(clicked()), this, SLOT(on_snapShotBrowse()));
	connect (historyBrowse, SIGNAL(clicked()), this, SLOT(on_historyBrowse()));
	connect (mameInfoBrowse, SIGNAL(clicked()), this, SLOT(on_mameInfoBrowse()));
	connect (cheatBrowse, SIGNAL(clicked()), this, SLOT(on_cheatBrowse()));
	connect (messCheatBrowse, SIGNAL(clicked()), this, SLOT(on_messCheatBrowse()));
	connect (highscoreBrowse, SIGNAL(clicked()), this, SLOT(on_highscoreBrowse()));
	connect (controllerBrowse, SIGNAL(clicked()), this, SLOT(on_controllerBrowse()));
	connect (highscorePathBrowse, SIGNAL(clicked()), this, SLOT(on_highscorePathBrowse()));
	connect (recordBrowse, SIGNAL(clicked()), this, SLOT(on_recordBrowse()));
	connect (gameConfigBrowse, SIGNAL(clicked()), this, SLOT(on_gameConfigBrowse()));
	connect (nvramBrowse, SIGNAL(clicked()), this, SLOT(on_nvramBrowse()));
	connect (iniBrowse, SIGNAL(clicked()), this, SLOT(on_iniBrowse()));
	connect (memoryBrowse, SIGNAL(clicked()), this, SLOT(on_memoryBrowse()));
	connect (gameStatusBrowse, SIGNAL(clicked()), this, SLOT(on_gameStatusBrowse()));
	connect (diffBrowse, SIGNAL(clicked()), this, SLOT(on_diffBrowse()));
	connect (mameMessRadioGroup, SIGNAL(clicked(int)), this, SLOT(on_mameMessRadio()));
	connect (messSysinfoPathBrowse, SIGNAL(clicked()), this, SLOT(on_sysinfoBrowse()));
	connect (messBiosPathBrowse, SIGNAL(clicked()), this, SLOT(on_messBiosBrowse()));
	connect (messSnapPathBrowse, SIGNAL(clicked()), this, SLOT(on_messSnapBrowse()));
	connect (alternativeBrowse, SIGNAL(clicked()), this, SLOT(on_alternativeBrowse()));
	
	alternativeCheck->setChecked(gui_prefs.allowAlternative);
	alternativeFrame->setEnabled(gui_prefs.allowAlternative);
	connect (alternativeCheck, SIGNAL(toggled(bool)), this, SLOT(setAllowAlternative(bool)));
	
	connect (sampleAdd, SIGNAL(clicked()), this, SLOT(addSample()));
	connect (romAdd, SIGNAL(clicked()), this, SLOT(addRom()));
	connect (execAdd, SIGNAL(clicked()), this, SLOT(addExec()));
	connect (sampleRemove, SIGNAL(clicked()), this, SLOT(removeSample()));
	connect (romRemove, SIGNAL(clicked()), this, SLOT(removeRom()));
	connect (execRemove, SIGNAL(clicked()), this, SLOT(removeExec()));

	/* Some settings that couldnot be done using QTDesigner */
	layout45->setStretchFactor(layout42_3,4);
	layout45->setStretchFactor(layout27,9);
	layout47->setStretchFactor(layout41,4);
	layout47->setStretchFactor(layout26,9);

}

void dirSelectionDialog::on_mameMessRadio()
{
	bool curMessRadio = messRadioButton->isChecked();
	if( curMessRadio == messRadioOff )
	{
		/* mess and mame radio switched */
		QString tmpStr;
		tmpStr = highscorePathEdit->text();	highscorePathEdit->setText(mHighScore); mHighScore = tmpStr;
		tmpStr = recordEdit->text();		recordEdit->setText(mRecord); 		mRecord = tmpStr;
		tmpStr = gameConfigEdit->text();	gameConfigEdit->setText(mConfig); 	mConfig = tmpStr;
		tmpStr = nvramEdit->text();		nvramEdit->setText(mNvram); 		mNvram = tmpStr;
		tmpStr = memoryEdit->text();		memoryEdit->setText(mMemory); 		mMemory = tmpStr;
		tmpStr = gameStatusEdit->text();	gameStatusEdit->setText(mStatus); 	mStatus = tmpStr;
		tmpStr = iniEdit->text();		iniEdit->setText(mIni); 		mIni = tmpStr;
		tmpStr = diffEdit->text();		diffEdit->setText(mDiff); 		mDiff = tmpStr;
		
		messRadioOff = !curMessRadio;
	}
}

void dirSelectionDialog::setAllowAlternative( bool state)
{
	alternativeFrame->setEnabled(state);
}

void dirSelectionDialog::create_folderselection (QLineEdit *current_entry,
					bool select_dir)
{
	QString cur_text, temp_text;

	cur_text = current_entry->text();
	if (select_dir) {
		temp_text = QFileDialog::getExistingDirectory(cur_text,
				this, 0,
				i18n("Browse for Folder"),TRUE);
	} else {
		temp_text = QFileDialog::getOpenFileName(cur_text,
				QString::null,
				this, 0,
				i18n("Browse for File"));
	}

	if (temp_text != QString::null) {
		GXMAME_DEBUG ("selected: {%s}", temp_text);
		current_entry->setText(temp_text);
	}
}

void dirSelectionDialog::addSample()
{
	uint i, size;
	bool already_exist = FALSE;

	if (strcmp (sampleEdit->text(), "")) {
		/* Check if what we are trying to add is not already in the list */
		already_exist = FALSE;
		size = sampleList->count();
		if (size) {
			for (i = 0; i < size; i++) {
				if ( (!strcmp (sampleList->text(i),sampleEdit->text()+"/")) ||
					(!strcmp (sampleList->text(i),sampleEdit->text())) )
					already_exist = TRUE;
			}
		}

		if (!already_exist) {
			sampleList->insertItem(sampleEdit->text());
		} else {
			gxmame_message (WARNING, 0, "Sample Path already in the list.");
		}
	}

}

void dirSelectionDialog::addRom() 
{	
	uint i, size;
	bool already_exist = FALSE;

	if (strcmp (romEdit->text(), "")) {
		/* Check if what we are trying to add is not already in the list */
		already_exist = FALSE;
		size = romList->count();
		if (size) {
			for (i = 0; i < size; i++) {
				if ( (!strcmp (romList->text(i),romEdit->text()+"/")) ||
						(!strcmp (romList->text(i),romEdit->text())) )
					already_exist = TRUE;
			}
		}

		if (!already_exist) {
			romList->insertItem(romEdit->text());
		} else {
			gxmame_message (WARNING, 0, "Rom Path already in the list.");
		}
	}
}

void dirSelectionDialog::addExec() 
{
	uint i, size;
	bool already_exist = FALSE;

	if (strcmp (execEdit->text(), "")) {
		/* Check if what we are trying to add is not already in the list */
		already_exist = FALSE;
		size = execList->count();
		if (size) {
			for (i = 0; i < size; i++) {
				if (!strcmp (execList->text(i),execEdit->text())) 
					already_exist = TRUE;
			}
		}

		if (!already_exist) {
			execList->insertItem(execEdit->text());
		} else {
			gxmame_message (WARNING, 0, "Executable already in the list.");
		}
	}
}

void dirSelectionDialog::removeSample()
{
	int cur_item = sampleList->currentItem();
	
	if(cur_item != -1)
		sampleList->removeItem(cur_item);
}

void dirSelectionDialog::removeRom()
{
	int cur_item = romList->currentItem();
	
	if(cur_item != -1)
		romList->removeItem(cur_item);
}

void dirSelectionDialog::removeExec()
{
	int cur_item = execList->currentItem();
	
	if(cur_item != -1)
		execList->removeItem(cur_item);
}

#include "dirselectiondialog.moc"
