/***************************************************************************
 *   Copyright (C) 2005 by Nguyen The Toan   *
 *   nguyenthetoan@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef _KXMAMEVIEW_H_
#define _KXMAMEVIEW_H_

#include <qwidget.h>
#include <qlabel.h>
#include <qtextedit.h>
#include <qpoint.h>
#include <qlayout.h>
#include <qsplitter.h>
#include <qtimer.h>
#include <kdebug.h>
#include <klistbox.h>
#include <klistview.h>
#include <kpopupmenu.h>
#include <kapplication.h>
#include <kmainwindow.h>
#include <ksplashscreen.h>
#include <klistviewsearchline.h>

#include "ColorListViewItem.h"
#include "kxmamesnaptab.h"
#include "kxmameSplash.h"
#include "katefileselector.h"
#include "game_list.h"

extern "C" {
#include "unzip.h"
}

extern bool globalIsMess;

class QPainter;

/**
 * This is the main view class for kxmame.  Most of the non-menu,
 * non-toolbar, and non-statusbar (e.g., non frame) GUI code should go
 * here.
 *
 * This kxmame uses an HTML component as an example.
 *
 * @short Main view
 * @author Nguyen The Toan <nguyenthetoan@gmail.com>
 * @version 0.1
 */
class kxmameView : public QWidget
{
	Q_OBJECT
public:

	kxmameView(QWidget *parent);
	virtual ~kxmameView();

	void finalize();
	
	void changeGameListView(ListMode newMode);
	void updateFilterList();
	void filterGames();
	//void quickFilter(folder_filters_list folderType, gchar *folderValue);
	
	void updateGameListView();
	
	void setupGameIcons();
	void saveGameColumnWidth();
	void saveGameColumnSort();
	void restoreGameColumnWidth();
	
	void setupMameMessView();
	void select_next_executable() { emit signalSelectNextExec(); }
	
	void updateVideoPreview();
	void stopVideo();	
	void setScaledScreenshot();

	KListView *GameListView() { return gameListView; }
	KListView *GameFilterList() { return gameFilterList; }
	int GameNameColumnId() { return globalIsMess?0:gameNameColumnId; }
	KateFileSelector *MessRomSelector() { return mMessRomSelector; }
	bool isSearchToolbarShown() { return showSearch; }
	RomEntry *currentRom();

	KPopupMenu *gameListContextMenu;
	QSplitter* splitter4;
	QSplitter* splitter3;
	KToolBar *searchToolBar, *systemUtilsToolbar;
	
signals:
	
	void signalChangeStatusbar(RomEntry *tmprom);
	void signalChangeCaption(const QString& text);
	
	void signalChangeExpandCollapse();
	void signalChangeFavorite(bool);
	
	void signalSetupMameMessUI();
	void signalSelectNextExec();

public slots:
	void slotGameListDoubleClicked();
	
public slots:

	void playGame();
	void playGameAlternative();
	void playRecordGame();
	void playbackGame();
	//void playRandomGame();
	void addFavorites();
	void removeFavorites();
	void listView();
	void listTreeView();
	void detailView();
	void detailTreeView();
	void collapseGameList();
	void expandGameList();
	void columnsLayout();
	
	void toggleFilter();
	void toggleSide();
	void toggleSearch();
	
	void slotFolderFilterChanged(QListViewItem *);
	void slotGameListSelectionChanged();
	void slotGameListSelectionChangedDelayed();
	
	void gameListContext(KListView *, QListViewItem *, const QPoint &);

protected:
	void tree(bool);
	void sortGameList();
	bool set_history (const QString entry_name, QString *text_buffer);
	bool set_info (const QString entry_name, QString *text_buffer);
	
	bool showSearch;
	int gameNameColumnId;
	KMainWindow *mParent;
	QHBoxLayout *top_layout;
	KListView* gameFilterList;
	KListView* gameListView;
	KateFileSelector *mMessRomSelector;
	class kxmameSnapTab *mScreenTab;
	QTextEdit* gameInfoView;
	QTimer *mTimer;
	bool inDelay;
	
	QPixmap get_icon_for_rom (RomEntry *rom, guint size, ZIP *zip);

};

const QString column_title (int column_num);


#endif // _KXMAMEVIEW_H_
