package com.limegroup.gnutella.gui;

import java.io.File;
import java.util.Date;

/**
 * GroupModel is a TreeTableModel representing a hierarchical set of groups.
 * 
 */

public class GroupModel extends AbstractTreeTableModel 
                             implements TreeTableModel {

    // Names of the columns.
    static protected String[]  cNames = {"Group", "Description"};

    // Types of the columns.
    static protected Class[]  cTypes = {TreeTableModel.class, String.class};


    public GroupModel(GroupNode root) { 
        super(root); 
    }

    //
    // Some convenience methods. 
    //

    protected String getGroup(Object node) {
        GroupNode groupNode = ((GroupNode)node); 
        return groupNode.getGroup();       
    }

    protected String getDescription(Object node) {
        GroupNode groupNode = ((GroupNode)node); 
        return groupNode.getDescription();       
    }

    protected Object[] getChildren(Object node) {
        GroupNode groupNode = ((GroupNode)node); 
        return groupNode.getChildren(); 
    }

    //
    // The TreeModel interface
    //

    public int getChildCount(Object node) { 
        Object[] children = getChildren(node); 
        return (children == null) ? 0 : children.length;
    }

    public Object getChild(Object node, int i) { 
        return getChildren(node)[i]; 
    }

    // The superclass's implementation would work, but this is more efficient. 
    public boolean isLeaf(Object node) {
	    if ( ((GroupNode)node).isForcedNonLeaf() )
			return false; 
	    return super.isLeaf(node); 
	}


    //
    //  The TreeTableNode interface. 
    //

    public int getColumnCount() {
        return cNames.length;
    }

    public String getColumnName(int column) {
        return cNames[column];
    }

    public Class getColumnClass(int column) {
        return cTypes[column];
    }
 
    public Object getValueAt(Object node, int column) {
        try {
            switch(column) {
            case 0:
                return getGroup(node);
            case 1:
                return getDescription(node);
            }
        }
        catch  (SecurityException se) { }
   
        return null; 
    }
}

