package com.limegroup.gnutella.gui;

/**
 * GroupNode is a Group with a descrition and children.
 * 
 */


public class GroupNode { 
    String   group; 
    String   description; 
    Object[] children; 
	boolean  forceNonGroup;

    public GroupNode(String group, String description, Object[] children) { 
        this.group       = group; 
        this.description = description; 
        this.children    = children; 
		forceNonGroup    = (children != null && children[0] == null);
		if ( forceNonGroup )
		    this.children = null;
    }

    /**
     * Returns the the string to be used to display this leaf in the JTree.
     */
    public String toString() { 
        return group;
    }

    public String getGroup() {
        return group; 
    }

    public String getDescription() {
        return description; 
    }

	public boolean isForcedNonLeaf() {
		return( forceNonGroup );
	}

    /**
     * returns the saved children.
     */
    protected Object[] getChildren() {
        return children; 
    }
}

