package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.util.CommonUtils;

import javax.swing.*;
import javax.swing.border.*;
import java.awt.*;
import java.awt.event.*;
import java.io.IOException;

/**
 * Contains the <tt>JDialog</tt> instance that shows PRO upgrade information
 * 
 */
//2345678|012345678|012345678|012345678|012345678|012345678|012345678|012345678|
final class PROWindow {	

	/**
	 * Constant handle to the <tt>JDialog</tt> that contains about 
	 * information.
	 */
	private JDialog dialog;

	/**
	 * Constant handle to the main <tt>BoxPanel</tt> instance.
	 */
	private final BoxPanel MAIN_PANEL = new BoxPanel(BoxPanel.Y_AXIS);

	/**
	 * Constant handle to the <tt>ImageIcon</tt> to use for the about 
	 * window.
	 */
	private final ImageIcon ICON = 
		GUIMediator.getThemeImage("searching.gif");

	/**
	 * Constant dimension for the dialog.
	 */
	private final Dimension DIALOG_DIMENSION = new Dimension(380, 180);


	/**
	 * Constructs the elements of the about window.
	 */
	PROWindow() {
		dialog = new JDialog(GUIMediator.instance().getAppFrame());
		dialog.setModal(true);
		dialog.setResizable(true);
		dialog.setTitle(GUIMediator.getStringResource("PRO_TITLE"));

		// set the main panel's border
		Border border = BorderFactory.createEmptyBorder(12,6,6,6);

		BoxPanel topPanel = new BoxPanel(BoxPanel.X_AXIS);
		topPanel.add(new JLabel(ICON));
		topPanel.add(GUIMediator.getHorizontalSeparator());
		topPanel.add(GUIMediator.getHorizontalSeparator());
		topPanel.add(GUIMediator.getHorizontalSeparator());
		String labelStart = 
		    GUIMediator.getStringResource("PRO_LABEL_THANKS");
		String labelEnd = 
		    GUIMediator.getStringResource("PRO_LABEL_QUESTION");
		MultiLineLabel label = new MultiLineLabel(labelStart, 290);
		label.setFont(new Font("Dialog", Font.BOLD, 12));
		JLabel label2 = new JLabel(labelEnd);
		label2.setFont(new Font("Dialog", Font.BOLD, 12));

		BoxPanel labelPanel = new BoxPanel(BoxPanel.Y_AXIS);
		labelPanel.add(Box.createVerticalGlue());
		labelPanel.add(label);
		labelPanel.add(Box.createVerticalStrut(10));
		BoxPanel questionPanel = new BoxPanel(BoxPanel.X_AXIS);
		questionPanel.add(Box.createVerticalGlue());
		questionPanel.add(label2);
		questionPanel.add(Box.createVerticalGlue());

		//Dimension labelDim = new Dimension(320, 50);
		//labelPanel.setPreferredSize(labelDim);
		//labelPanel.setMaximumSize(labelDim);

		topPanel.add(labelPanel);

		MAIN_PANEL.setBorder(border);
		MAIN_PANEL.setPreferredSize(DIALOG_DIMENSION);
		dialog.setSize(DIALOG_DIMENSION);
		
		ActionListener upgradeDialogListener = new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				try {
			        GUIMediator.openURL(
				      "http://www.limewire.com/index.jsp/pro");	
				} catch(IOException ioe) {
					// all we can do is try to launch it
				}
				dialog.dispose();
				dialog.setVisible(false);
			}
		};
		ActionListener whyDialogListener = new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				try {
			        GUIMediator.openURL(
				      "http://www.limewire.com/promote/whygopro");	
				} catch(IOException ioe) {
					// all we can do is try to launch it
				}
				dialog.dispose();
				dialog.setVisible(false);
			}
		};

		ActionListener closeDialogListener = new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				dialog.dispose();
				dialog.setVisible(false);
			}
		};

		String[] buttonKeys = {
			"YES",
			"WHYGOPRO",
			"GO_PRO_LATER"
		};

		String[] buttonTips = {
			"GO_PRO_TIP",
			"WHYGOPRO_TIP",
			"GO_PRO_LATER_TIP"
		};

		ActionListener[] listeners = {
			upgradeDialogListener,
			whyDialogListener,
			closeDialogListener
		};

		ButtonRow buttons = 
		    new ButtonRow(buttonKeys, buttonTips, listeners);

		MAIN_PANEL.add(topPanel);
		MAIN_PANEL.add(questionPanel);
		MAIN_PANEL.add(Box.createVerticalStrut(10));
		MAIN_PANEL.add(buttons);
		dialog.getContentPane().add(MAIN_PANEL);
		dialog.pack();
	}

	/**
	 * Displays the "PRO" dialog window to the user.
	 */
	void showDialog() {
		dialog.setLocationRelativeTo(GUIMediator.getAppFrame());
		dialog.setVisible(true);
	}
}
