package com.limegroup.gnutella.gui.connection;

import com.limegroup.gnutella.gui.tables.AbstractTableMediator;
import com.limegroup.gnutella.gui.*;
import javax.swing.*;
import java.awt.event.*;
import java.awt.*;

/**
 * This class contains the buttons in the connection window, allowing
 * classes in this package to enable or disable buttons at specific
 * indeces in the row.
 */
final class ConnectionButtons {


	/**
	 * The row of buttons for the donwload window.
	 */
	private ButtonRow BUTTONS;

	/**
	 * The index of the remove button in the button row.
	 */
	static final int REMOVE_BUTTON  = 0;

	/**
	 * The index of the add button in the button row.
	 */
	static final int ADD_BUTTON = 1;
	
	/**
	 * The constructor creates the row of buttons with their associated
	 * listeners.
	 */
	ConnectionButtons(final ConnectionMediator cm) {
        String[] buttonLabelKeys = {
			"CV_BUTTON_REMOVE",
			"CV_BUTTON_ADD"
		};
        String[] buttonTipKeys = {
			"CV_BUTTON_TOOLTIP_REMOVE",
			"CV_BUTTON_TOOLTIP_ADD"
		};

		ActionListener[] buttonListeners = {
			cm.REMOVE_LISTENER,
			cm.ADD_LISTENER
		};

		BUTTONS = new ButtonRow(buttonLabelKeys,buttonTipKeys,buttonListeners,
		           ButtonRow.X_AXIS, ButtonRow.NO_GLUE);
	}
	
	ButtonRow getComponent() { return BUTTONS; }
	
}
