package com.limegroup.gnutella.gui.menu;

import com.apple.eawt.*;
import com.limegroup.gnutella.gui.*;

public class CocoaApplicationEventHandler implements ApplicationListener {

    // Handle to the Cocoa Application interface
    private final Application _app = new Application();

    /**
     * For MacOSX, Java 1.4 access to Cocoa subsystem.  See the methods 
     * handleAbout(), handleOpenApplication(), handleOpenFile(),
     * handlePreferences, handlePrintFile(), handleQuit()
     */
    public CocoaApplicationEventHandler() {
    }

    /**
     * Sets the 'Preferences' menu to be enabled and handles when a user selects
     * it (through handlePreferences()) .
     */
    public void register() {
        _app.addApplicationListener(this);
        _app.setEnabledPreferencesMenu(true);
    }

    //--------------------------------------------------------------------------
    // ApplicationListener interface implementation
    //--------------------------------------------------------------------------

    
    public void handleAbout(ApplicationEvent event) {}

    public void handleOpenApplication(ApplicationEvent event) {}

    public void handleOpenFile(ApplicationEvent event) {
        PackagedMediaFileLauncher.launchFile(event.getFilename(), false);
    }

    public void handleOpenDocument(ApplicationEvent event) {}

    public void handlePrintDocument(ApplicationEvent event) {}

    public void handlePreferences(ApplicationEvent event) {
        // turn on that badboy (options)
        GUIMediator.instance().setOptionsVisible(true);
    }

    public void handlePrintFile(ApplicationEvent event) {}

    public void handleQuit(ApplicationEvent event) {}

}
