package com.limegroup.gnutella.gui.menu;

import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.gui.*;
import com.limegroup.gnutella.util.CommonUtils;
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

/**
 * The menu item that actually displays the options for dynamically
 * showing or hiding tabs.
 */
final class ShowHideMenu extends AbstractMenu {

    /**
     * The menu item for the monitor tab.
     */
    private JMenuItem MONITOR_ITEM = null;
    /**
     * The menu item for the connections tab.
     */
    private JMenuItem CONNECTIONS_ITEM = null;
    /**
     * The menu item for the shopping tab.
     */
    private JMenuItem SHOPPING_ITEM = null;
    /**
     * The menu item for the library tab.
     */
    private JMenuItem LIBRARY_ITEM = null;
    

    /**
     * Constructs all of the elements of the <tt>ViewMenu</tt>, in particular
     * the check box menu items and listeners for the various tabs displayed
     * in the main window.
     *
     * @param key the key allowing the <tt>AbstractMenu</tt> superclass to
     *  access the appropriate locale-specific string resources
     */
    ShowHideMenu(final String key) {
        super(key);
        
        MONITOR_ITEM = 
            addToggleMenuItem("VIEW_MONITOR",  
                        new ViewListener(GUIMediator.MONITOR_INDEX), 
                        ApplicationSettings.MONITOR_VIEW_ENABLED.getValue());
        CONNECTIONS_ITEM = 
            addToggleMenuItem("VIEW_CONNECTIONS", 
                        new ViewListener(GUIMediator.CONNECTIONS_INDEX), 
                        ApplicationSettings.CONNECTION_VIEW_ENABLED.getValue());
        LIBRARY_ITEM = 
            addToggleMenuItem("VIEW_LIBRARY", 
                        new ViewListener(GUIMediator.LIBRARY_INDEX), 
                        ApplicationSettings.LIBRARY_VIEW_ENABLED.getValue());

		// Conditionally add Shopping Entry
		if (!GUIMediator.hasDonated() && CommonUtils.isWindows() &&
            GUIMediator.isBrowserPageLoaded())	
        	SHOPPING_ITEM = 
            	addToggleMenuItem("VIEW_SHOPPING", 
              	  new ShoppingViewListener(GUIMediator.SHOPPING_INDEX), 
              	  ApplicationSettings.SHOPPING_VIEW_ENABLED.getValue());
    }

	/**
	 * Listener for the checking/unchecking of the menu buttons, making
	 * the associated tabs visible or invisible.
	 */
    private static class ViewListener implements ActionListener {
		
		/**
		 * The fixed index for the associated tab (see GUIMediator tab 
		 * indeces).
		 */
		private final int INDEX;

		/**
		 * Constructs a new <tt>ViewListener</tt> with the specified fixed
		 * index.
		 *
		 * @param INDEX the fixed index for the associated tab
		 */
		private ViewListener(final int INDEX) {
			this.INDEX = INDEX;			
		}

        public void actionPerformed(ActionEvent ae) {
			try {
				AbstractButton button = (AbstractButton)ae.getSource();
				GUIMediator.instance().setTabVisible(INDEX, button.isSelected());
			    GUIMediator.instance().setWindow(INDEX);	
			} catch(Exception e) {
				GUIMediator.showInternalError(e);
			}
        }
    }
	/**
	 * Listener for the checking/unchecking of the menu buttons, making
	 * the associated tabs visible or invisible.
	 */
    private static class ShoppingViewListener implements ActionListener {
		
		/**
		 * The fixed index for the associated tab (see GUIMediator tab 
		 * indeces).
		 */
		private final int INDEX;

		/**
		 * Constructs a new <tt>ViewListener</tt> with the specified fixed
		 * index.
		 *
		 * @param INDEX the fixed index for the associated tab
		 */
		private ShoppingViewListener(final int INDEX) {
			this.INDEX = INDEX;			
		}

        public void actionPerformed(ActionEvent ae) {
			try {
				AbstractButton button = (AbstractButton)ae.getSource();
				GUIMediator.instance().setTabVisible(INDEX, button.isSelected());
			    GUIMediator.instance().setWindow(INDEX);	
			    GUIMediator.instance().wakeupShoppingView();
			} catch(Exception e) {
				GUIMediator.showInternalError(e);
			}
        }
    }
}