package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.settings.*;
import com.limegroup.gnutella.gui.options.OptionsMediator;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.*;
import javax.swing.*;
import java.io.*;

/**
 * Class allowing or disallowing the row striping for tables..
 */
public final class RowStripePaneItem extends AbstractPaneItem {

	/**
	 * Constant for the key of the locale-specific <tt>String</tt> for the 
	 * row striping enabled check box label..
	 */
    private final String ROW_STRIPE_LABEL = 
        "OPTIONS_ROW_STRIPE_DISPLAY_CHECK_BOX_LABEL";
    
    /**
	 * Constant for the check box that specifies whether to enable or 
	 * disable row striping
	 */
    private final JCheckBox CHECK_BOX = new JCheckBox();
    
    /**
	 * The constructor constructs all of the elements of this 
	 * <tt>AbstractPaneItem</tt>.
	 *
	 * @param key the key for this <tt>AbstractPaneItem</tt> that the
	 *            superclass uses to generate locale-specific keys
	 */
    public RowStripePaneItem(final String key) {
        super(key);
        LabeledComponent c = 
            new LabeledComponent(ROW_STRIPE_LABEL,
                                 CHECK_BOX,
                                 LabeledComponent.LEFT_GLUE);
        
        add(c.getComponent());
    }

    /**
	 * Defines the abstract method in <tt>AbstractPaneItem</tt>.<p>
	 *
	 * Sets the options for the fields in this <tt>PaneItem</tt> when the 
	 * window is shown.
	 */
    public void initOptions() {
        CHECK_BOX.setSelected(UISettings.ROW_STRIPE_ENABLED.getValue());
    }

    /**
	 * Defines the abstract method in <tt>AbstractPaneItem</tt>.<p>
	 *
	 * Applies the options currently set in this window, displaying an
	 * error message to the user if a setting could not be applied.
	 *
	 * @throws IOException if the options could not be applied for some reason
	 */
    public void applyOptions() throws IOException {
        UISettings.ROW_STRIPE_ENABLED.setValue(CHECK_BOX.isSelected());
    }
}


