package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.*;
import com.limegroup.gnutella.xml.*;
import com.limegroup.gnutella.gui.*;

import com.sun.java.util.collections.*;
import java.util.MissingResourceException;


public class NamedMediaType {
    MediaType _mediaType;
    String _name;
    
    public NamedMediaType(MediaType mt) {
        this._mediaType = mt;
        try {
            //get the String from the resource bundle by looking up the mt name
            final String descriptionKey = mt.getDescription();
            _name = (descriptionKey == null) ? null
                : GUIMediator.getStringResource(descriptionKey);
        } catch (MissingResourceException mre) {
            _name = null;
        }
        if (_name == null)
            _name = LimeXMLUtils.capitalizeFirst(mt.toString()); //lets be defensive (ignore the description key)
    }
    
    public String toString(){
        return _name;
    }
    
    public MediaType getUnderLyingMediaType() {
        return _mediaType;
    }
    
    static List convertMediaTypes(MediaType[] mtArray) {
        int size = mtArray.length;
        List retList = new ArrayList();
        for (int i = 0; i < size; i++)
            retList.add(new NamedMediaType(mtArray[i]));
        return retList;
    }
    
    static boolean isDefaultType(String type) {
        return MediaType.isDefaultType(type);
    }
}
