package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.*;
import javax.swing.*;
import java.awt.event.*;

/**
 * Factory class for generating the right-click menu on search 
 * results.
 */
final class SearchResultMenu {

    /**
     * Private constructor to ensure that this class can never be
     * created.
     */
    private SearchResultMenu() {}

    /**
     * Creates a new <tt>JPopupMenu</tt> instance with <tt>JMenuItem</tt>s
     * that are appropriately enabled or disabled depending on whether
     * or not rows are selected and depending on the state of the 
     * <tt>TableLine</tt>.
     *
     * @param line the <tt>TableLine</tt> containting data for customizing 
     *  the <tt>JPopupMenu</tt> 
     * @param rowsSelected <tt>boolean</tt> for whether or not rows are
     *  selected
     * @param PANEL the <tt>ResultPanel</tt> for performing functions like
     *  launching a web browser
     */
    static JPopupMenu createMenu(TableLine line, boolean rowsSelected,
                                 final ResultPanel PANEL) {
        JPopupMenu menu = new JPopupMenu();
        JMenuItem downloadAllEntry = 
            new JMenuItem(SearchMediator.DOWNLOAD_STRING);
        downloadAllEntry.addActionListener(new DownloadAllAction());
        menu.add(downloadAllEntry);

        JMenuItem chatItem = new JMenuItem(SearchMediator.CHAT_STRING);
        chatItem.addActionListener(new ChatListener());
        menu.add(chatItem);

        JMenuItem bitziLookupItem = 
            new JMenuItem(SearchMediator.BITZI_LOOKUP_STRING);
        bitziLookupItem.addActionListener(new BitziLookupAction());
        menu.add(bitziLookupItem);

        JMenuItem browseHostItem = 
            new JMenuItem(SearchMediator.BROWSE_HOST_STRING);
        browseHostItem.addActionListener(new BrowseHostAction());
        menu.add(browseHostItem);

        JMenuItem blockHostItem = 
            new JMenuItem (SearchMediator.BLOCK_STRING);
        blockHostItem.addActionListener(new BlockListener());
        menu.add(blockHostItem);

        /////////////////////////////
        menu.addSeparator();

        JMenuItem repeatSearchEntry = 
            new JMenuItem(SearchMediator.REPEAT_SEARCH_STRING);
        repeatSearchEntry.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent ae) {
                try {
                    PANEL.repeatSearch();
                } catch(Throwable e) {
                    GUIMediator.showInternalError(e, "RepeatSearch");
                }
            }
        });

        menu.add(repeatSearchEntry);

        JMenuItem stopEntry =
            new JMenuItem(SearchMediator.STOP_STRING);
        stopEntry.addActionListener(new StopListener());
        menu.add(stopEntry);

        JMenuItem cancelEntry =
            new JMenuItem(SearchMediator.KILL_STRING);
        cancelEntry.addActionListener(new CancelAction());
        menu.add(cancelEntry);


        /////////////////////////
        menu.addSeparator();

        JMenuItem launchItem = 
            new JMenuItem(SearchMediator.LAUNCH_STRING);
        launchItem.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent ae) {
                try {
                    PANEL.launchBrowser();
                } catch(Throwable e) {
                    GUIMediator.showInternalError(e, "Search.LaunchBrowser");
                }
            }
        });
        menu.add(launchItem);       

        if(!rowsSelected) {//no lines selected? Disable chat
            chatItem.setEnabled(false);
            browseHostItem.setEnabled(false);
        } 

        if(line != null) {
            //enable if line says so
            chatItem.setEnabled(line.getChatEnabled());
            
            // enable if SHA1 available
            bitziLookupItem.setEnabled(line.getSHA1() != null); 
            browseHostItem.setEnabled(line.getBrowseHostEnabled());
        }
        return menu;
    }
}
