package com.limegroup.gnutella.update.gui;

import com.limegroup.gnutella.gui.*;
import com.limegroup.gnutella.*;
import javax.swing.*;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;

/** 
 * Creates a new update panel for prompting the user for whether 
 * or not they would like to update. 
 */
final class UpdatePanel {
	
	/**
	 * Handle to the <tt>JDialog</tt> for the panel.
	 */
	private final JDialog DIALOG;// = new JDialog();
	
	/**
	 * Variable for the code for the user response.
	 */
	private int _responseCode;
	
	/**
	 * Constant for the user response to update later.
	 */
	final static int UPDATE_LATER = 10;
	
	/**
	 * Constant for the user response to update now.
	 */
	final static int UPDATE_NOW = 11;

	static UpdatePanel createUpdatePanelWithParentFrame(String msg) {
		return new UpdatePanel(msg, true);
	}

	static UpdatePanel createFloatingUpdatePanel(String msg) {
		return new UpdatePanel(msg, false);
	}
	
	/**
	 * Constructs the pane that prompts the user for whether or not
	 * they would like to update the program.
	 *
	 * @param msg the message to display to the user regarding
	 *  the update
	 */
	private UpdatePanel(String msg, boolean useMainFrame) {
		final int WIDTH = 360;
		final int HEIGHT = 250;
		//DIALOG.setSize(WIDTH, HEIGHT);
		if(useMainFrame) {
			DIALOG = new JDialog(GUIMediator.getAppFrame());
		} else {
			DIALOG = new JDialog();
		}
		DIALOG.setModal(true);
		DIALOG.setTitle(GUIMediator.getStringResource("UPDATE_DIALOG_CAPTION"));
		
		MultiLineLabel label = new MultiLineLabel(msg, WIDTH-40);
		
		String[] buttonLabels = {
		    "YES",
		    "NO"
		};
		
		String[] buttonTips = {
		    "UPDATE_NOW_TIP",
		    "UPDATE_LATER_TIP"
		};
		
		ActionListener[] buttonListeners = {
		    new UpdateNowListener(),
		    new UpdateLaterListener()
		};
		
		JPanel mainPanel = new JPanel();
		mainPanel.setBorder(BorderFactory.createEmptyBorder(6,6,6,6));
		mainPanel.add(label);
		ButtonRow buttonRow = 
		    new ButtonRow(buttonLabels, buttonTips, buttonListeners);
		Container contentPane = DIALOG.getContentPane();
		contentPane.setLayout(new BoxLayout(contentPane, BoxLayout.Y_AXIS));
		contentPane.add(mainPanel);
		contentPane.add(Box.createVerticalGlue());
		contentPane.add(buttonRow);
        DIALOG.pack();
	}
	
	/**
	 * Shows the update prompt to the user.
	 * 
	 * @return the user response code, either <tt>UPDATE_NOW</tt> or 
	 *  <tt>UPDATE_LATER</tt>
	 */
	int showDialog() {	    
		DIALOG.setLocation(GUIMediator.getScreenCenterPoint(DIALOG));
	    DIALOG.setVisible(true);
	    return _responseCode;
	}
	
	/**
	 * Class for responding to mouse clicks on the button for updating now.
	 * This sets the response code, initiates the update, and makes the window 
	 * invisible.
	 */
	private final class UpdateNowListener implements ActionListener {
	    public void actionPerformed(ActionEvent e) {
	        UpdatePanel.this._responseCode = UPDATE_NOW;
	        UpdatePanel.this.DIALOG.setVisible(false);
	        UpdatePanel.this.DIALOG.dispose();
	    }
	}
	
	/**
	 * Class for responding to mouse clicks on the button for updating later.
	 * This sets the response code and makes the window invisible.
	 */
	private final class UpdateLaterListener implements ActionListener {
	    public void actionPerformed(ActionEvent e) {
	        UpdatePanel.this._responseCode = UPDATE_LATER;
	        UpdatePanel.this.DIALOG.setVisible(false);
	        UpdatePanel.this.DIALOG.dispose();
	    }
	}

    /*
    public static void main(String[] args) {
        UpdatePanel panel = 
            new UpdatePanel("There is a new update for LimeWire available with "+
                            "the best damn features ever.  Would you like to "+
                            "update now, or would you rather do something "+
                            "different?");
        
        panel.showDialog();
    }
    */
}
