/****************************************************************************
**
** Copyright (C) 2001-2004 Frank Hemer.
**
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** LinCVS is available under two different licenses:
**
** If LinCVS is linked against the GPLed version of Qt 
** LinCVS is released under the terms of GPL also.
**
** If LinCVS is linked against a nonGPLed version of Qt 
** LinCVS is released under the terms of the 
** LinCVS License for non-Unix platforms (LLNU)
**
**
** LinCVS License for non-Unix platforms (LLNU):
**
** Redistribution and use in binary form, without modification, 
** are permitted provided that the following conditions are met:
**
** 1. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
** 2. It is not permitted to distribute the binary package under a name
**    different than LinCVS.
** 3. The name of the authors may not be used to endorse or promote
**    products derived from this software without specific prior written
**    permission.
** 4. The source code is the creative property of the authors.
**    Extensions and development under the terms of the Gnu Public License
**    are limited to the Unix platform. Any distribution or compilation of 
**    the source code against libraries licensed other than gpl requires 
**    the written permission of the authors.
**
**
** THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR 
** IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
** ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY 
** DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
** NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**
**
** LinCVS License for Unix platforms:
**
** This program is free software; you can redistribute it and/or modify 
** it under the terms of the GNU General Public License as published by 
** the Free Software Foundation; either version 2 of the License, or 
** (at your  option) any later version.  This program is distributed in 
** the hope that it will be useful, but WITHOUT ANY WARRANTY; without 
** even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
** PARTICULAR PURPOSE.
**
** See the GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software Foundation,
** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
*****************************************************************************/


#include "config.h"

#include <qwhatsthis.h>
#include <qpushbutton.h>

#include "globals.h"
#include "CustomizeDialogImpl.h"


CustomizeDialogImpl::CustomizeDialogImpl(QVector<MenuItem> *choice, QVector<MenuItem> *preset,
					 const QIconSet &whatsThisIconSet,
					 QWidget* parent, const char* name, bool modal, WFlags f)
//  : CustomizeDialog( LookAndFeel::g_b0AsParent ? 0 : parent, name, modal, f)
  : CustomizeDialog( modal ? parent : (LookAndFeel::g_b0AsParent ? 0 : parent),
		     name, modal, f)
{
  m_pWhatsThis->setIconSet(whatsThisIconSet);
#ifdef Q_WS_MAC
  m_pWhatsThis->setMaximumWidth(m_pWhatsThis->height() * 2);
#else
  m_pWhatsThis->setMaximumWidth(m_pWhatsThis->height());
#endif

  p_preset = preset;
  m_choice = QVector<MenuItem> (0);
  m_preset = QVector<MenuItem> (0);
  int pos = 0;
  int i;
  
  //fill local preset (what's in menu already)
  m_preset.resize(p_preset->size());
  for (i = 0; i<(int)p_preset->count(); i++) {
    m_preset.insert(i,(*p_preset)[i]);
  }
  //fill selectBox
  for(i = 0; i<(int)p_preset->count(); i++ ) {
    QString txt = (*p_preset)[i]->caption();
    if ( (*p_preset)[i]->getFirstChild()) {
      txt += " ";
      txt += tr("(submenu)");
    }
    selectedBox->insertItem(txt);
  }
  //find and fill local choice (what is left and not in menu yet)
  m_choice.resize(choice->count());
  for (i = 0; i<(int)choice->count(); i++) {
    bool found=false;
    for (int c = 0; c<(int)m_preset.count(); c++) {
      if ((*choice)[i]->getInstanceNum()==m_preset[c]->getInstanceNum() && !((*choice)[i]->count()==0)) {
	found=true;
	break;
      }
    }
    if (!found) {
      m_choice.insert(pos++,(*choice)[i]);
    }
  }
  m_choice.resize(m_choice.count());
  //fill choiceBox
  for(i = 0; i<(int)m_choice.count(); i++ ) {
    QString txt = m_choice[i]->caption();
    if (m_choice[i]->getFirstChild()) {
      txt += " ";
      txt += tr("(submenu)");
    }
    choiceBox->insertItem(txt);
  }
}

CustomizeDialogImpl::~CustomizeDialogImpl() {
}

void CustomizeDialogImpl::add() {
  int from = choiceBox->currentItem();
  int to = selectedBox->currentItem()+1;
  if (from>-1) {
    if (to==-1) to = m_preset.count()-1;//to end of list
    m_preset.resize(m_preset.count()+1);
    for (int i = m_preset.size()-1; i>to; i--) m_preset.insert(i,m_preset[i-1]);
    m_preset.insert(to,(m_choice[from]));
    QString txt = m_preset[to]->caption();
    if (m_preset[to]->getFirstChild()) {
      txt += " ";
      txt += tr("(submenu)");
    }
    selectedBox->insertItem(txt,to);
    if (needsRemove(m_choice[from])) {
      for (int i = from; i<(int)m_choice.count()-1;i++) m_choice.insert(i,m_choice[i+1]);
      m_choice.remove(m_choice.count()-1);
      m_choice.resize(m_choice.count());
      choiceBox->removeItem(from);
    }
    selectedBox->setSelected(to,true);
  }
}

void CustomizeDialogImpl::remove() {
  int from = selectedBox->currentItem();
  if (from>-1) {
    if (m_preset[from]->id()==DP_Customize) return;//never remove customize entry
    if (!m_choice.contains(m_preset[from])) {
      QString txt = m_preset[from]->caption().lower();
      int pos;
      for (pos = 0;pos<(int)m_choice.count();pos++)
	if (m_choice[pos]->caption().lower().compare(txt) > 0) break;
      m_choice.resize(m_choice.size()+1);
      for (int i = m_choice.size()-1; i>pos; i--) m_choice.insert(i,m_choice[i-1]);
      m_choice.insert(pos,(m_preset[from]));
      txt = m_preset[from]->caption();
      if (m_preset[from]->getFirstChild()) {
	txt += " ";
	txt += tr("(submenu)");
      }
      choiceBox->insertItem(txt,pos);
    }
    for (int i = from; i<(int)m_preset.size()-1; i++) m_preset.insert(i,m_preset[i+1]);
    m_preset.remove(m_preset.count()-1);
    m_preset.resize(m_preset.count());
    selectedBox->removeItem(from);
    choiceBox->clearSelection();
    selectedBox->clearSelection();
  }
}

void CustomizeDialogImpl::up() {
  int pos = selectedBox->currentItem();
  if (pos>0) {
    MenuItem *tmp = m_preset[pos-1];
    m_preset.insert(pos-1,m_preset[pos]);
    m_preset.insert(pos,tmp);
    selectedBox->removeItem(pos);
    QString txt = m_preset[pos-1]->caption();
    if (m_preset[pos-1]->getFirstChild()) {
	txt += " ";
	txt += tr("(submenu)");
    }
    selectedBox->insertItem(txt,pos-1);
    selectedBox->setSelected(pos-1,true);
    selectedBox->ensureCurrentVisible();
  }
}

void CustomizeDialogImpl::down() {
  int pos = selectedBox->currentItem();
  if (pos>-1 && pos<(int)m_preset.count()-1) {
    MenuItem *tmp = m_preset[pos+1];
    m_preset.insert(pos+1,m_preset[pos]);
    m_preset.insert(pos,tmp);
    selectedBox->removeItem(pos);
    QString txt = m_preset[pos+1]->caption();
    if (m_preset[pos+1]->getFirstChild()) {
	txt += " ";
	txt += tr("(submenu)");
    }
    selectedBox->insertItem(txt,pos+1);
    selectedBox->setSelected(pos+1,true);
    selectedBox->ensureCurrentVisible();
  }
}

void CustomizeDialogImpl::done() {
  (*p_preset).resize(m_preset.size());
  for (int i = 0;i<(int)m_preset.count();i++) {
    (*p_preset).insert(i,m_preset[i]);
  }
}

bool CustomizeDialogImpl::needsRemove(MenuItem *item) {
  if (item->count()>0 && (int)m_preset.contains(item)==item->count()) return true;
  return false;
}

void CustomizeDialogImpl::enterWhatsThisMode()
{
   QWhatsThis::enterWhatsThisMode();
}
