/****************************************************************************
 **
 ** Copyright (C) 2001-2004 The LinCVS development team.
 **    Tilo Riemer <riemer@lincvs.org>
 **    Falk Brettschneider <gigafalk@yahoo.com>
 **    Frank Hemer <frank@hemer.org>
 **    Wim Delvaux <wim.delvaux@chello.be>
 **    Jose Hernandez <joseh@tesco.net>
 **    Helmut Koll <HelmutKoll@web.de>
 **    Tom Mishima <tmishima@mail.at-m.or.jp>
 **    Joerg Preiss <auba@auba.de>
 **    Sven Trogisch <trogisch@iapp.de>
 **
 **
 **----------------------------------------------------------------------------
 **
 **----------------------------------------------------------------------------
 **
 ** LinCVS is available under two different licenses:
 **
 ** If LinCVS is linked against the GPLed version of Qt 
 ** LinCVS is released under the terms of GPL also.
 **
 ** If LinCVS is linked against a nonGPLed version of Qt 
 ** LinCVS is released under the terms of the 
 ** LinCVS License for non-Unix platforms (LLNU)
 **
 **
 ** LinCVS License for non-Unix platforms (LLNU):
 **
 ** Redistribution and use in binary form, without modification, 
 ** are permitted provided that the following conditions are met:
 **
 ** 1. Redistributions in binary form must reproduce the above copyright
 **    notice, this list of conditions and the following disclaimer in the
 **    documentation and/or other materials provided with the distribution.
 ** 2. It is not permitted to distribute the binary package under a name
 **    different than LinCVS.
 ** 3. The name of the authors may not be used to endorse or promote
 **    products derived from this software without specific prior written
 **    permission.
 ** 4. The source code is the creative property of the authors.
 **    Extensions and development under the terms of the Gnu Public License
 **    are limited to the Unix platform. Any distribution or compilation of 
 **    the source code against libraries licensed other than gpl requires 
 **    the written permission of the authors.
 **
 **
 ** THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR 
 ** IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 ** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 ** ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY 
 ** DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
 ** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
 ** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 ** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 ** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
 ** NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
 ** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 **
 **
 **
 ** LinCVS License for Unix platforms:
 **
 ** This program is free software; you can redistribute it and/or modify 
 ** it under the terms of the GNU General Public License as published by 
 ** the Free Software Foundation; either version 2 of the License, or 
 ** (at your  option) any later version.  This program is distributed in 
 ** the hope that it will be useful, but WITHOUT ANY WARRANTY; without 
 ** even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 ** PARTICULAR PURPOSE.
 **
 ** See the GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program; if not, write to the Free Software Foundation,
 ** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 **
 *****************************************************************************/


#include "config.h"

#include <qaction.h>
#include <qwhatsthis.h>     
#include <qiconset.h>
#include <qwidget.h>
#include <qstring.h>
#include <qapplication.h>
#include <qlayout.h>
#include <qtoolbar.h>

#include "globals.h"
#include "cvstoolbar.h"

// pixmaps 
#include "pixmapcache.h"

// -- internal objects ---------------------------------------------------

static const QString whatsThisTextInt[]= {
  
   /* add2Wb */
   QObject::tr("<html>"
	 "<p>"
	 "<u><b>Add project to workbench:</b></u><br>"
	 "Click this button to add a <em>new folder</em> to the workbench.<br>" 
	 "As an alternative, you can select <br> <b>Project -> Add project to Workbench ...</b><br> from the menu."
	 "</p>"
	 "</html>"),
  
   /* stopAction */
   QObject::tr("<html>"
	 "<p>"
	 "<u><b>Emergency stop:</b></u><br>"
	 "When highlighted and the button is clicked, any current action is terminated immediately.<br>"
	 "When disabled nothing happens."
	 "</p>"
	 "</html>"),

   /* exit */
   QObject::tr("<html>"
	 "<p>"
	 "Exit LinCVS."
	 "</p>"
	 "</html>"),

   /* info */
   QObject::tr("<html>"
	 "<p>"
	 "<u><b>Info:</b></u><br>"
	 "Click this button to get some information about this program "
	 "like the authors and GNU GPL.<br>"
	 "As an alternative, you can select <nobr><b>Help -> About</b></nobr> from the menu."
	 "</p>"
	 "</html>"),

   /* import */
   QObject::tr("<html>"
	 "<p>"
	 "<u><b>Import:</b></u><br>"
	 "Click this button to <em>import</em> a new project or folder "
	 "into the CVS repository. It's <b>not</b> a <em>cvs check in </em>, but puts a new "
	 "project under cvs control.<br>"
	 "As an alternative, you can select <nobr><br><b>Project -> Import ...</b></nobr><br>from the menu."
	 "</p>"
	 "</html>"),
   
   /* co */
   QObject::tr("<html>"
	 "<p>"
	 "<u><b>Checkout:</b></u><br>"
	 "Click this button to <em>check out</em> a project from the CVS repository "
	 "into your workbench.<br>As an alternative, you can select <nobr><br><b>Project -> Checkout ...</b></nobr><br>"
	 "from the menu."
	 "</p>"
	 "</html>"),
 
   /* upd */
   QObject::tr("<html>"
	 "<p>"
	 "<u><b>Refresh:</b></u><br>"
	 "Click this button to refresh the status of your modules.<br>"
	 "Normally this is done automatically due to the timer settings and you should never "
	 "need to use it.<br> But users who have performance problems and use a long refresh period "
	 "or have maybe deactivated auto-refresh, can trigger the refresh manually.<br>"
	 "<nobr><b>This doesn't change your sandbox, it only rescans its contents.</b></nobr><br>"
	 "As an alternative, you can select <nobr><br><b>Project -> Refresh</b></nobr> from the menu.<br>"
	 "</p>"
	 "</html>"),

   /* autoupd */
   QObject::tr("<html>"
	 "<p>"
	 "<u><b>Auto update:</b></u><br>"
	 "Push this button to enable the auto update mechanism.<br>"
	 "All projects configured to use the Auto-Update feature will be updated automatically "
	 "every X (e.g. every minute). X is the time interval you have set in "
	 "<nobr><b>Config -> Settings ... -> LinCVS Options -> AutoUpdate</b></nobr>.<br>"
	 "The autoupdate property can be set with <nobr><b>Directory -> Project -> Properties</b></nobr>."
	 "</p>"
	 "</html>"),

   /* cvsupd */
   QObject::tr("<html>"
	 "<p>"
	 "<u><b>Update:</b></u><br>"
	 "When you have marked a folder and/or file individually, clicking this "
	 "button will update those specific items. As an alternative, you can "
         "select this function from the menu, or from the contextual menu."
	 "</p>"
	 "</html>"),

   /* cvscom */
   QObject::tr("<html>"
	 "<p>"
	 "<u><b>Commit:</b></u><br>"
	 "When you have marked a folder and/or file individually, clicking this "
	 "button will run commit on those specific items. As an alternative, you can "
         "select this function from the menu, or from the contextual menu."
	 "</p>"
	 "</html>"),

   /* cvs merge */
   QObject::tr("<html>"
	 "<p>"
	 "<u><b>Merge:</b></u><br>"
	 "When you have marked a folder and/or file individually, clicking this "
	 "button will open a dialog where you can specify which versions to merge. "
         "If <b>OK</b> is clicked, cvs merge is run.<br>"
         "As an alternative, you can select this function from the menu, or from the contextual menu, "
	 "or merge from within one of the dialogs (Log tree, Merge)."
	 "</p>"
	 "</html>"),

   /* annotate */
   QObject::tr("<html>"
	 "<p>"
	 "<u><b>Annotate:</b></u><br>"
	 "When you have marked a folder and/or file individually, clicking this "
	 "button will run cvs annotate on those specific items. As an alternative, you can "
         "select this function from the menu, or from the contextual menu."
	 "</p>"
	 "</html>"),

   /* annotate grep line */
   QObject::tr("<html>"
	 "<p>"
	 "<u><b>Annotate one line:</b></u><br>"
	 "When you have marked a folder and/or file individually, clicking this "
	 "button will open a dialog where you can specify what line to search for "
	 "in the annotation of the selection. Only matching "
	 "lines will show up in the result.<br>"
         "As an alternative, you can select this function from the menu, or from the contextual menu."
	 "</p>"
	 "</html>"),

   /* annotate grep lines */
   QObject::tr("<html>"
	 "<p>"
	 "<u><b>Annotate specific lines:</b></u><br>"
	 "When you have marked a folder and/or file individually, clicking this "
	 "button will open a dialog where you can specify which lines to search for "
	 "in the annotation of the selection. Only matching "
	 "lines will show up in the result.<br>"
         "As an alternative, you can select this function from the menu, or from the contextual menu."
	 "</p>"
	 "</html>"),

   /* watch add */
   QObject::tr("<html>"
	 "<p>"
	 "<u><b>Watch add:</b></u><br>"
	 "When you have marked a folder and/or file individually, clicking this "
	 "button will enable the notification mechanism (if one is configured) "
         "on those specific items on the server side.<br>"
	 "All future <b>edit, unedit and commit</b> commands of other users will "
         "trigger this notification for you.<br>"
         "As an alternative, you can "
         "select this function from the menu, or from the contextual menu."
	 "</p>"
	 "</html>"),

   /* watch remove */
   QObject::tr("<html>"
	 "<p>"
	 "<u><b>Watch remove:</b></u><br>"
	 "When you have marked a folder and/or file individually, clicking this "
	 "button will disable the notification mechanism (if one is configured) "
         "on those specific items on the server side.<br>"
	 "All future <b>edit, unedit and commit</b> commands of other users will no longer "
         "trigger this notification for you.<br>"
         "As an alternative, you can "
         "select this function from the menu, or from the contextual menu."
	 "</p>"
	 "</html>"),

   /* watch on */
   QObject::tr("<html>"
	 "<p>"
	 "<u><b>Watch on:</b></u><br>"
	 "When you have marked a folder and/or file individually, clicking this button "
         "causes any further scm-invoked creation of local files from those specific items "
         "to be read-only. Thus, users will be reminded to use <b>edit</b> first.<br>"
         "As an alternative, you can "
         "select this function from the menu, or from the contextual menu."
	 "</p>"
	 "</html>"),

   /* watch off */
   QObject::tr("<html>"
	 "<p>"
	 "<u><b>Watch off:</b></u><br>"
	 "When you have marked a folder and/or file individually, clicking this button "
         "causes any further scm-invoked creation of local files from those specific items "
         "to be writeable, if not explicitly configured to readonly, "
         "<nobr>see <b>(Config -> Settings -> CVS Global)</b></nobr>. Thus, other users will no more be "
	 "reminded to use <b>edit</b> first.<br>"
         "As an alternative, you can "
         "select this function from the menu, or from the contextual menu."
	 "</p>"
	 "</html>")

};

// -- external objects ---------------------------------------------------

static const QString whatsThisText[]= {
  
   /* wbench */
   QObject::tr("<html>"
	 "<p>"
	 "<u><b>This is your workbench:</b></u><br>"
	 "In this area all the folders are listed that you have already checked out with LinCVS. "
	 "Additionally all folders you have added with the command <br>"
	 "<b>Project -> Add to Workbench ...</b><br>are listed here.<br>"
	 "</p>"
	 "<p>"
	 "The icon on a folder reflects the state of all its files and subdirs. A higher state "
	 "overrides lower states. A parent folder shows the maximum priority of itself and its children.<br>"
	 "<nobr>The individual states are (ordered hierarchically, from top [low] down):</nobr>"
	 "</p>"
	 "<p>"
	 "<nobr><img source=\"FolderDisabled16x16\"> folder is disabled<br></nobr>"
	 "<nobr><img source=\"FolderStatus16x16\"> folder is not under scm control<br></nobr>"
	 "<nobr><img source=\"FolderClosed16x16\"> all files seem up to date<br></nobr>"
	 "<nobr><img source=\"FolderClosedNonCVS16x16\"> there are non-controlled file(s)/dirs<br></nobr>"
	 "<nobr><img source=\"FolderClosedModified16x16\"> some file(s) are modified<br></nobr>"
	 "<nobr><img source=\"FolderClosedUncommitted16x16\"> there are uncommitted changes<br></nobr>"
	 "<nobr><img source=\"FolderClosedWarn16x16\"> some file(s) need an update<br></nobr>"
	 "<nobr><img source=\"FolderClosedProblem16x16\"> some file(s) have conflicts<br></nobr>"
	 "<nobr><img source=\"FolderMissing16x16\"> folder is missing<br></nobr>"
	 "</p>"
	 "<p>"
	 "<img source=\"anchor_12x16\"> A project can have several subprojects. Each subproject is symbolized with an "
	 "<img source=\"anchor_12x16\"> to visualize its independant status."
	 "</p>"
	 "</html>"),

   /* cvsFile */  
   QObject::tr("<html>"
	 "<p>"
	 "<u><b>These are the controlled contents of the selected folder:</b></u><br>"
	 "Provided a folder is selected from the workbench, in this area all <em>checked out</em> " 
	 "files are listed together with some status information described in the headline. "
	 "This information is updated periodically due to the timer settings. LinCVS keeps track "
	 "with changes even if they are caused from outside LinCVS, i.e. by a cvs commandline call. "
	 "After clicking on a file with the right mouse button a contextual menu is opened."
	 "</p>"
	 "<p>"
	 "The icon of a file reflects its state.<br>"
	 "<nobr>The individual states are:</nobr>"
	 "<p>"
	 "<nobr><img source=\"FileRemoved16x16\"> file is locally removed (uncommitted)<br></nobr>"
	 "<nobr><img source=\"FileAdded16x16\"> file is locally added (uncommitted)<br></nobr>"
	 "<nobr><img source=\"FileUnchanged16x16\"> file is unchanged (readonly)<br></nobr>"
	 "<nobr><img source=\"FileWriteable16x16\"> file is unchanged (writeable)<br></nobr>"
	 "<nobr><img source=\"FileModified16x16\"> file is modified<br></nobr>"
	 "<nobr><img source=\"FileNeedsPatch16x16\"> file needs update (new version on server)<br></nobr>"
	 "<nobr><img source=\"FileNeedsMerge16x16\"> file needs update (new version on server)<br></nobr>"
	 "<nobr><img source=\"FileNeedsCheckout16x16\"> file is missing (needs update)<br></nobr>"
	 "<nobr><img source=\"FileConflict16x16\"> file has/had conflicts (uncommitted)<br></nobr>"
	 "</p>"
	 "</html>"),

   /* nonCvsFile */
   QObject::tr("<html>"
	 "<p>"
	 "<u><b>These are the non-controlled contents of the selected folder:</b></u><br>"
	 "In this area all the files are listed which are currently not under control. "
	 "To put a file under control (add a file to the repository) just click it with your "
	 "right mouse button, choose one of the add options and do a commit afterwards."
	 "</p>"
	 "<p>"
	 "The icon of a file reflects its state.<br>"
	 "<nobr>The individual states are:</nobr>"
	 "</p>"
	 "<p>"
	 "<nobr><img source=\"FileUnknown16x16\"> file is writeable<br></nobr>"
	 "<nobr><img source=\"FileLocked16x16\"> file is readonly<br></nobr>"
	 "<nobr><img source=\"FolderStatus16x16\"> folder is not controlled<br></nobr>"
	 "<nobr><img source=\"FolderClosedLocked16x16\"> folder is not readable<br></nobr>"
	 "</p>"
	 "</html>"),

   /* cvs ignore */
   QObject::tr("<html>"
	 "<p>"
	 "<u><b>These are the ignored contents of the selected folder:</b></u><br>"
	 "In this area all the files are listed that the scm will ignore when operating on a dir.<br>"
	 "The contents depends on the settings in ~/.cvsignore, the CVSIGNORE environment variable and the .cvsignore files in "
	 "all the directories under cvs control in this order. The files to ignore are selected via wildcards, "
	 "an ! (exclamation mark) will reset all previous settings."
	 "</p>"
	 "</html>"),

   /* tabFileList */
   QObject::tr("<html>"
	 "<p>"
	 "Provided a folder is selected from the workbench, the directory contents "
	 "is listed in these three tabs:<br><nobr><em>Controlled</em>, "
	 "<em>Non-controlled</em> and <em>Ignored</em></nobr> files."
	 "</p>"
	 "</html>"),
  
   /* status */
   QObject::tr("<html>"
	 "<p>"
	 "Here you find the generated output from calls to the scm system, like status, diff, log .. etc.<br>"
	 "This output is provided for your convenience only."
	 "</p>"
	 "</html>")
};


 
/*---------------------------------------------------------------------------*
 *  Prototypes / classes                                                     *
 *---------------------------------------------------------------------------*/

cvsToolbar::cvsToolbar (QMainWindow *parent) : QToolBar(parent)
{
   // create buttons for toolbar    
   QIconSet is_exit(findEmbeddedPixmap("quit_16x16"));
   is_exit.setPixmap(findEmbeddedPixmap("quit_disabled_16x16"), QIconSet::Automatic, QIconSet::Disabled);
   tb_exit = new QToolButton(is_exit,
	 tr("Exit application"), QString::null,
	 qApp, SLOT(closeAllWindows()), this, "Exit");

   this->addSeparator();

   QIconSet is_stop(findEmbeddedPixmap("stop_16x16"));
   is_stop.setPixmap(findEmbeddedPixmap("stop_disabled_16x16"), QIconSet::Automatic, QIconSet::Disabled);
   m_pStopAction = new QToolButton(is_stop,
	 tr("Stop Action"), QString::null, parent, 
	 SLOT(stopCurAction()), this, "stop action");  

   m_pStopAction->setEnabled(false);

   this->addSeparator();

   QIconSet is_cvsUpd(findEmbeddedPixmap("update_16x16"));
   is_cvsUpd.setPixmap(findEmbeddedPixmap("update_disabled_16x16"), QIconSet::Automatic, QIconSet::Disabled);
   tb_cvsUpd = new QToolButton (is_cvsUpd,
	 tr("cvs update"), QString::null, parent,
	 SLOT(slot_updateAny()), this, "Update");

   QIconSet is_commit(findEmbeddedPixmap("commit_16x16"));
   is_commit.setPixmap(findEmbeddedPixmap("commit_disabled_16x16"), QIconSet::Automatic, QIconSet::Disabled);
   tb_com = new QToolButton (is_commit,
	 tr("cvs commit"), QString::null, parent, 
	 SLOT(slot_commitAny()), this, "Commit");

   QIconSet is_cvsMerge(findEmbeddedPixmap("merge_16x16"));
   is_cvsMerge.setPixmap(findEmbeddedPixmap("merge_disabled_16x16"), QIconSet::Automatic, QIconSet::Disabled);
   tb_cvsMerge = new QToolButton (is_cvsMerge,
	 tr("cvs merge"), QString::null, parent,
	 SLOT(slot_mergeAny()), this, "Merge");

   QIconSet is_co(findEmbeddedPixmap("checkout_16x16"));
   is_co.setPixmap(findEmbeddedPixmap("checkout_disabled_16x16"), QIconSet::Automatic, QIconSet::Disabled);
   tb_co = new QToolButton (is_co,
	 tr("cvs check out"), QString::null, parent,
	 SLOT(slot_checkoutProject()), this, "check out");

   QIconSet is_imp(findEmbeddedPixmap("CmdImport32x32"));
   is_imp.setPixmap(findEmbeddedPixmap("CmdImport_disabled_32x32"), QIconSet::Automatic, QIconSet::Disabled);
   tb_imp = new QToolButton (is_imp,
	 tr("cvs import"), QString::null, parent,
	 SLOT(slot_importProject()), this, "import");

   this->addSeparator();

   QIconSet is_addWb(findEmbeddedPixmap("module_add_16x16"));
   is_addWb.setPixmap(findEmbeddedPixmap("module_add_disabled_16x16"), QIconSet::Automatic, QIconSet::Disabled);
   tb_addWb = new QToolButton (is_addWb,
	 tr("add to workbench"), QString::null, parent, 
	 SLOT(slot_addProject()), this, "open file");

   QIconSet is_upd(findEmbeddedPixmap("module_status_16x16"));
   is_upd.setPixmap(findEmbeddedPixmap("module_status_disabled_16x16"), QIconSet::Automatic, QIconSet::Disabled);
   tb_upd = new QToolButton (is_upd,
	 tr("update module status"), QString::null, parent, 
	 SLOT(slot_checkStatus()), this, "update");
     
   QIconSet is_autoupd(findEmbeddedPixmap("module_autoupdate_16x16"));
   is_autoupd.setPixmap(findEmbeddedPixmap("module_autoupdate_disabled_16x16"), QIconSet::Automatic, QIconSet::Disabled);
   tb_autoupd = new QToolButton (is_autoupd,
	 tr("autoupdate"), QString::null, this,
	 SLOT(toggle_autoupdate()), this, "autoupdate");
   tb_autoupd->setToggleButton(TRUE);

   this->addSeparator();   

   QIconSet is_annotate(findEmbeddedPixmap("cvs_annotate_16x16"));
   is_annotate.setPixmap(findEmbeddedPixmap("cvs_annotate_disabled_16x16"), QIconSet::Automatic, QIconSet::Disabled);
   tb_annotate = new QToolButton (is_annotate,
	 tr("cvs annotate"), QString::null, parent, 
	 SLOT(slot_annotateAny()), this, "annotate");
   QIconSet is_annotateGrepLine(findEmbeddedPixmap("who_changed_line_16x16"));
   is_annotateGrepLine.setPixmap(findEmbeddedPixmap("who_changed_line_disabled_16x16"), QIconSet::Automatic, QIconSet::Disabled);
   tb_annotateGrepLine = new QToolButton (is_annotateGrepLine,
	 tr("Who has changed which line?"), QString::null, parent, 
	 SLOT(slot_annotateGrepLineAny()), this, "annotate_grep_line");
   QIconSet is_annotateGrepLines(findEmbeddedPixmap("who_changed_lines_16x16"));
   is_annotateGrepLines.setPixmap(findEmbeddedPixmap("who_changed_lines_disabled_16x16"), QIconSet::Automatic, QIconSet::Disabled);
   tb_annotateGrepLines = new QToolButton (is_annotateGrepLines,
	 tr("Who has changed which lines?"), QString::null, parent, 
	 SLOT(slot_annotateGrepLinesAny()), this, "annotate_grep_lines");

   this->addSeparator();   

   QIconSet is_watchAdd(findEmbeddedPixmap("cvs_watch_add_16x16"));
   is_watchAdd.setPixmap(findEmbeddedPixmap("cvs_watch_add_disabled_16x16"), QIconSet::Automatic, QIconSet::Disabled);
   tb_watchAdd = new QToolButton (is_watchAdd,
	 tr("cvs watch add"), QString::null, parent, 
	 SLOT(slot_watchAddAny()), this, "watch add");
   QIconSet is_watchRemove(findEmbeddedPixmap("cvs_watch_remove_16x16"));
   is_watchRemove.setPixmap(findEmbeddedPixmap("cvs_watch_remove_disabled_16x16"), QIconSet::Automatic, QIconSet::Disabled);
   tb_watchRemove = new QToolButton (is_watchRemove,
	 tr("cvs watch remove"), QString::null, parent, 
	 SLOT(slot_watchRemoveAny()), this, "watch remove");
   QIconSet is_watchOn(findEmbeddedPixmap("cvs_watch_on_16x16"));
   is_watchOn.setPixmap(findEmbeddedPixmap("cvs_watch_on_disabled_16x16"), QIconSet::Automatic, QIconSet::Disabled);
   tb_watchOn = new QToolButton (is_watchOn,
	 tr("cvs watch on"), QString::null, parent, 
	 SLOT(slot_watchOnAny()), this, "watch on");
   QIconSet is_watchOff(findEmbeddedPixmap("cvs_watch_off_16x16"));
   is_watchOff.setPixmap(findEmbeddedPixmap("cvs_watch_off_disabled_16x16"), QIconSet::Automatic, QIconSet::Disabled);
   tb_watchOff = new QToolButton (is_watchOff,
	 tr("cvs watch off"), QString::null, parent, 
	 SLOT(slot_watchOffAny()), this, "watch off");

   this->addSeparator();   

   QIconSet is_info(findEmbeddedPixmap("lincvs-16"));
   is_info.setPixmap(findEmbeddedPixmap("lincvs_disabled_16x16"), QIconSet::Automatic, QIconSet::Disabled);
   tb_info = new QToolButton (is_info,
	 tr("info"), QString::null, parent, 
	 SLOT(slot_about()), this, "info");

   QToolButton* pWhatsThis = QWhatsThis::whatsThisButton (this);
   m_whatsThisIconSet = pWhatsThis->iconSet();        
        
   /* Make the toolbar stretch the width or height of the
    * main window depending on orientation.
    */
   setHorizontalStretchable(true);
   setVerticalStretchable(true);

   this->addWhatsThisTextInt (tb_addWb, add2Wb);
   this->addWhatsThisTextInt (m_pStopAction, stopAction);
   this->addWhatsThisTextInt (tb_exit, exit );
   this->addWhatsThisTextInt (tb_info, info);
   this->addWhatsThisTextInt (tb_imp, import);
   this->addWhatsThisTextInt (tb_co, co);
   this->addWhatsThisTextInt (tb_upd, upd);
   this->addWhatsThisTextInt (tb_autoupd, autoupd);
   this->addWhatsThisTextInt (tb_cvsUpd, cvsupd);
   this->addWhatsThisTextInt (tb_com, cvscom);
   this->addWhatsThisTextInt (tb_cvsMerge, cvsmerge);
   this->addWhatsThisTextInt (tb_annotate, annotate);
   this->addWhatsThisTextInt (tb_annotateGrepLine, annotateGrepLine);
   this->addWhatsThisTextInt (tb_annotateGrepLines, annotateGrepLines);
   this->addWhatsThisTextInt (tb_watchAdd, watchAdd);
   this->addWhatsThisTextInt (tb_watchRemove, watchRemove);
   this->addWhatsThisTextInt (tb_watchOn, watchOn);
   this->addWhatsThisTextInt (tb_watchOff, watchOff);

   //set config state
   autoUpdateChanged();
}

void cvsToolbar::autoUpdateChanged() {
   tb_autoupd->setOn(AUTOUPDATE);
}

void cvsToolbar::toggle_autoupdate() {

   if (tb_autoupd->isOn() != AUTOUPDATE) {
      AUTOUPDATE = tb_autoupd->isOn();
      emit autoUpdateStateChanged();
   }

}


/*---------------------------------------------------------------------------*/
/*!
  \fn			cvsToolbar::~cvsToolbar(void)
  \brief		dtor.

  <BR><HR>*/
/*---------------------------------------------------------------------------*/

cvsToolbar::~cvsToolbar(void) { }



/*---------------------------------------------------------------------------*/
/*!
  \fn			void cvsToolbar::addWhatsThisTextInt(QToolButton *tb, T_wtTextInt textType )
  \brief		For internal toolbuttons

  \param		*tb		toolbutton
  \param		textType		index of QString whatsThisTextInt[]

  <BR><HR>*/
/*---------------------------------------------------------------------------*/

void cvsToolbar::addWhatsThisTextInt(QToolButton *tb, T_wtTextInt textType )
{
   QWhatsThis::add( (QWidget*)tb, tr(whatsThisTextInt[textType]) );
}


/*---------------------------------------------------------------------------*/
/*!
  \fn			void cvsToolbar::addWhatsThisText( void *ptr,  T_wtText textType  )
  \brief		for external objects

  \param		*ptr		poiter to object
  \param		textType		index of QString whatsThisText[]

  <BR><HR>*/
/*---------------------------------------------------------------------------*/

void cvsToolbar::addWhatsThisText( void *ptr,  T_wtText textType  )
{
   switch(textType) {
      case wBench: {
	 QMimeSourceFactory::defaultFactory()->setPixmap( "FolderDisabled16x16",
	       findEmbeddedPixmap("FolderDisabled16x16") );
	 QMimeSourceFactory::defaultFactory()->setPixmap( "FolderStatus16x16",
	       findEmbeddedPixmap("FolderStatus16x16") );
	 QMimeSourceFactory::defaultFactory()->setPixmap( "FolderClosed16x16",
	       findEmbeddedPixmap("FolderClosed16x16") );
	 QMimeSourceFactory::defaultFactory()->setPixmap( "FolderClosedNonCVS16x16",
	       findEmbeddedPixmap("FolderClosedNonCVS16x16") );
	 QMimeSourceFactory::defaultFactory()->setPixmap( "FolderClosedModified16x16",
	       findEmbeddedPixmap("FolderClosedModified16x16") );
	 QMimeSourceFactory::defaultFactory()->setPixmap( "FolderClosedUncommitted16x16",
	       findEmbeddedPixmap("FolderClosedUncommitted16x16") );
	 QMimeSourceFactory::defaultFactory()->setPixmap( "FolderClosedWarn16x16",
	       findEmbeddedPixmap("FolderClosedWarn16x16") );
	 QMimeSourceFactory::defaultFactory()->setPixmap( "FolderClosedProblem16x16",
	       findEmbeddedPixmap("FolderClosedProblem16x16") );
	 QMimeSourceFactory::defaultFactory()->setPixmap( "FolderMissing16x16",
	       findEmbeddedPixmap("FolderMissing16x16") );
	 QMimeSourceFactory::defaultFactory()->setPixmap( "anchor_12x16",
	       findEmbeddedPixmap("anchor_12x16") );
	 break;
      }
      case cvsFile: {
	 QMimeSourceFactory::defaultFactory()->setPixmap( "FileRemoved16x16",
	       findEmbeddedPixmap("FileRemoved16x16") );
	 QMimeSourceFactory::defaultFactory()->setPixmap( "FileUnchanged16x16",
	       findEmbeddedPixmap("FileUnchanged16x16") );
	 QMimeSourceFactory::defaultFactory()->setPixmap( "FileWriteable16x16",
	       findEmbeddedPixmap("FileWriteable16x16") );
	 QMimeSourceFactory::defaultFactory()->setPixmap( "FileModified16x16",
	       findEmbeddedPixmap("FileModified16x16") );
	 QMimeSourceFactory::defaultFactory()->setPixmap( "FileNeedsPatch16x16",
	       findEmbeddedPixmap("FileNeedsPatch16x16") );
	 QMimeSourceFactory::defaultFactory()->setPixmap( "FileNeedsMerge16x16",
	       findEmbeddedPixmap("FileNeedsMerge16x16") );
	 QMimeSourceFactory::defaultFactory()->setPixmap( "FileNeedsCheckout16x16",
	       findEmbeddedPixmap("FileNeedsCheckout16x16") );
	 QMimeSourceFactory::defaultFactory()->setPixmap( "FileConflict16x16",
	       findEmbeddedPixmap("FileConflict16x16") );
	 QMimeSourceFactory::defaultFactory()->setPixmap( "FileAdded16x16",
	       findEmbeddedPixmap("FileAdded16x16") );
	 break;
      }
      case nonCvsFile: {
	 QMimeSourceFactory::defaultFactory()->setPixmap( "FileLocked16x16",
	       findEmbeddedPixmap("FileLocked16x16") );
	 QMimeSourceFactory::defaultFactory()->setPixmap( "FileUnknown16x16",
	       findEmbeddedPixmap("FileUnknown16x16") );
	 QMimeSourceFactory::defaultFactory()->setPixmap( "FolderStatus16x16",
	       findEmbeddedPixmap("FolderStatus16x16") );
	 QMimeSourceFactory::defaultFactory()->setPixmap( "FolderClosedLocked16x16",
	       findEmbeddedPixmap("FolderClosedLocked16x16") );
	 break;
      }
      case cvsIgnoreFile: {
	 break;
      }
      default: {
	 break;
      }
   }
   QWhatsThis::add( (QWidget*)ptr, tr(whatsThisText[textType]) );  
}


//   Enable or disable all Buttons except stop

void cvsToolbar::setEnabled( bool state) {
   tb_exit->setEnabled(state);
   tb_cvsMerge->setEnabled(state);
   tb_cvsUpd->setEnabled(state);
   tb_com->setEnabled(state);
   tb_co->setEnabled(state);
   tb_imp->setEnabled(state);
   tb_addWb->setEnabled(state);
   tb_upd->setEnabled(state);
   tb_autoupd->setEnabled(state);
   tb_annotate->setEnabled(state);
   tb_annotateGrepLine->setEnabled(state);
   tb_annotateGrepLines->setEnabled(state);
   tb_watchAdd->setEnabled(state);
   tb_watchRemove->setEnabled(state);
   tb_watchOn->setEnabled(state);
   tb_watchOff->setEnabled(state);
   tb_info->setEnabled(state);
}
/*--------- END OF FILE -----------------------------------------------------*/
