/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hivemind.ant;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.Attribute;
import org.apache.hivemind.Element;
import org.apache.hivemind.ErrorHandler;
import org.apache.hivemind.ModuleDescriptorProvider;
import org.apache.hivemind.Occurances;
import org.apache.hivemind.impl.DefaultClassResolver;
import org.apache.hivemind.impl.DefaultErrorHandler;
import org.apache.hivemind.impl.XmlModuleDescriptorProvider;
import org.apache.hivemind.internal.Visibility;
import org.apache.hivemind.parse.AttributeMappingDescriptor;
import org.apache.hivemind.parse.ConfigurationPointDescriptor;
import org.apache.hivemind.parse.ContributionDescriptor;
import org.apache.hivemind.parse.ConversionDescriptor;
import org.apache.hivemind.parse.CreateInstanceDescriptor;
import org.apache.hivemind.parse.DependencyDescriptor;
import org.apache.hivemind.parse.ImplementationDescriptor;
import org.apache.hivemind.parse.InstanceBuilder;
import org.apache.hivemind.parse.InterceptorDescriptor;
import org.apache.hivemind.parse.InvokeFactoryDescriptor;
import org.apache.hivemind.parse.ModuleDescriptor;
import org.apache.hivemind.parse.ServicePointDescriptor;
import org.apache.hivemind.parse.SubModuleDescriptor;
import org.apache.hivemind.schema.AttributeModel;
import org.apache.hivemind.schema.ElementModel;
import org.apache.hivemind.schema.Rule;
import org.apache.hivemind.schema.impl.SchemaImpl;
import org.apache.hivemind.schema.rules.BaseRule;
import org.apache.hivemind.schema.rules.CreateObjectRule;
import org.apache.hivemind.schema.rules.InvokeParentRule;
import org.apache.hivemind.schema.rules.PushAttributeRule;
import org.apache.hivemind.schema.rules.PushContentRule;
import org.apache.hivemind.schema.rules.ReadAttributeRule;
import org.apache.hivemind.schema.rules.ReadContentRule;
import org.apache.hivemind.schema.rules.SetModuleRule;
import org.apache.hivemind.schema.rules.SetParentRule;
import org.apache.hivemind.schema.rules.SetPropertyRule;
import org.apache.hivemind.util.IdUtils;
import org.w3c.dom.Document;

public class RegistrySerializer {
    private Set _processedSchemas = new HashSet();
    private List _providers = new ArrayList();
    private ErrorHandler _handler = new DefaultErrorHandler();
    private Document _document;
    private ModuleDescriptor _md;

    public void addModuleDescriptorProvider(ModuleDescriptorProvider provider) {
        this._providers.add(provider);
    }

    public Document createRegistryDocument() {
        DocumentBuilder builder = this.getBuilder();
        this._document = builder.newDocument();
        org.w3c.dom.Element registry = this._document.createElement("registry");
        this._document.appendChild(registry);
        Iterator i = this._providers.iterator();
        while (i.hasNext()) {
            ModuleDescriptorProvider provider = (ModuleDescriptorProvider)i.next();
            this.processModuleDescriptorProvider(registry, provider);
        }
        return this._document;
    }

    private void processModuleDescriptorProvider(org.w3c.dom.Element registry, ModuleDescriptorProvider provider) {
        Iterator j = provider.getModuleDescriptors(this._handler).iterator();
        while (j.hasNext()) {
            this._md = (ModuleDescriptor)j.next();
            org.w3c.dom.Element module = this.getModuleElement(this._md);
            registry.appendChild(module);
        }
    }

    private org.w3c.dom.Element getModuleElement(ModuleDescriptor md) {
        org.w3c.dom.Element module = this._document.createElement("module");
        module.setAttribute("id", md.getModuleId());
        module.setAttribute("version", md.getVersion());
        module.setAttribute("package", md.getPackageName());
        module.appendChild(this._document.createTextNode(md.getAnnotation()));
        this.addDependencies(module);
        this.addServicePoints(module);
        this.addConfigurationPoints(module);
        this.addContributions(module);
        this.addImplementations(module);
        this.addSchemas(module);
        this.addSubModules(module);
        return module;
    }

    private void addDependencies(org.w3c.dom.Element module) {
        List dependencies = this._md.getDependencies();
        if (dependencies != null) {
            Iterator i = dependencies.iterator();
            while (i.hasNext()) {
                DependencyDescriptor dd = (DependencyDescriptor)i.next();
                org.w3c.dom.Element dependency = this.getDependencyElement(dd);
                module.appendChild(dependency);
            }
        }
    }

    private void addServicePoints(org.w3c.dom.Element module) {
        List servicePoints = this._md.getServicePoints();
        if (servicePoints != null) {
            Iterator i = servicePoints.iterator();
            while (i.hasNext()) {
                ServicePointDescriptor spd = (ServicePointDescriptor)i.next();
                org.w3c.dom.Element servicePoint = this.getServicePointElement(spd);
                module.appendChild(servicePoint);
                SchemaImpl s = spd.getParametersSchema();
                if (s == null || s.getId() == null) continue;
                this.addSchema(module, s, "schema");
            }
        }
    }

    private void addConfigurationPoints(org.w3c.dom.Element module) {
        List configurationPoints = this._md.getConfigurationPoints();
        if (configurationPoints != null) {
            Iterator i = configurationPoints.iterator();
            while (i.hasNext()) {
                ConfigurationPointDescriptor cpd = (ConfigurationPointDescriptor)i.next();
                org.w3c.dom.Element configurationPoint = this.getConfigurationPointElement(cpd);
                module.appendChild(configurationPoint);
                SchemaImpl s = cpd.getContributionsSchema();
                if (s == null || s.getId() == null) continue;
                this.addSchema(module, s, "schema");
            }
        }
    }

    private void addContributions(org.w3c.dom.Element module) {
        List contributions = this._md.getContributions();
        if (contributions != null) {
            Iterator i = contributions.iterator();
            while (i.hasNext()) {
                ContributionDescriptor cd = (ContributionDescriptor)i.next();
                org.w3c.dom.Element contribution = this.getContributionElement(cd);
                module.appendChild(contribution);
            }
        }
    }

    private void addImplementations(org.w3c.dom.Element module) {
        List implementations = this._md.getImplementations();
        if (implementations != null) {
            Iterator i = implementations.iterator();
            while (i.hasNext()) {
                ImplementationDescriptor id = (ImplementationDescriptor)i.next();
                org.w3c.dom.Element implementation = this.getImplementationElement(id);
                module.appendChild(implementation);
            }
        }
    }

    private void addSchemas(org.w3c.dom.Element module) {
        Collection schemas = this._md.getSchemas();
        Iterator i = schemas.iterator();
        while (i.hasNext()) {
            SchemaImpl s = (SchemaImpl)i.next();
            this.addSchema(module, s, "schema");
        }
    }

    private void addSubModules(org.w3c.dom.Element module) {
        List subModules = this._md.getSubModules();
        if (subModules != null) {
            Iterator i = subModules.iterator();
            while (i.hasNext()) {
                SubModuleDescriptor smd = (SubModuleDescriptor)i.next();
                org.w3c.dom.Element subModule = this.getSubModuleElement(smd);
                module.appendChild(subModule);
            }
        }
    }

    private org.w3c.dom.Element getDependencyElement(DependencyDescriptor dd) {
        org.w3c.dom.Element dependency = this._document.createElement("dependency");
        dependency.setAttribute("module-id", dd.getModuleId());
        dependency.setAttribute("version", dd.getVersion());
        return dependency;
    }

    private org.w3c.dom.Element getServicePointElement(ServicePointDescriptor spd) {
        List interceptors;
        org.w3c.dom.Element servicePoint = this._document.createElement("service-point");
        servicePoint.setAttribute("id", this.qualify(spd.getId()));
        servicePoint.setAttribute("interface", spd.getInterfaceClassName());
        if (spd.getVisibility() == Visibility.PRIVATE) {
            servicePoint.setAttribute("visibility", "private");
        }
        if (spd.getParametersCount() != Occurances.REQUIRED) {
            servicePoint.setAttribute("parameters-occurs", spd.getParametersCount().getName().toLowerCase());
        }
        servicePoint.appendChild(this._document.createTextNode(spd.getAnnotation()));
        if (spd.getParametersSchema() != null) {
            this.addSchema(servicePoint, spd.getParametersSchema(), "parameters-schema");
        } else if (spd.getParametersSchemaId() != null) {
            servicePoint.setAttribute("parameters-schema-id", this.qualify(spd.getParametersSchemaId()));
        }
        InstanceBuilder ib = spd.getInstanceBuilder();
        if (ib != null) {
            org.w3c.dom.Element instanceBuilder = this.getInstanceBuilderElement(ib);
            servicePoint.appendChild(instanceBuilder);
        }
        if ((interceptors = spd.getInterceptors()) != null) {
            Iterator i = interceptors.iterator();
            while (i.hasNext()) {
                InterceptorDescriptor icd = (InterceptorDescriptor)i.next();
                org.w3c.dom.Element interceptor = this.getInterceptorElement(icd);
                servicePoint.appendChild(interceptor);
            }
        }
        return servicePoint;
    }

    private org.w3c.dom.Element getConfigurationPointElement(ConfigurationPointDescriptor cpd) {
        org.w3c.dom.Element configurationPoint = this._document.createElement("configuration-point");
        configurationPoint.setAttribute("id", this.qualify(cpd.getId()));
        if (cpd.getVisibility() == Visibility.PRIVATE) {
            configurationPoint.setAttribute("visibility", "private");
        }
        configurationPoint.appendChild(this._document.createTextNode(cpd.getAnnotation()));
        if (cpd.getContributionsSchema() != null) {
            this.addSchema(configurationPoint, cpd.getContributionsSchema(), "schema");
        } else if (cpd.getContributionsSchemaId() != null) {
            configurationPoint.setAttribute("schema-id", this.qualify(cpd.getContributionsSchemaId()));
        }
        return configurationPoint;
    }

    private org.w3c.dom.Element getContributionElement(ContributionDescriptor cd) {
        List parameters;
        org.w3c.dom.Element contribution = this._document.createElement("contribution");
        contribution.setAttribute("configuration-id", this.qualify(cd.getConfigurationId()));
        if (cd.getConditionalExpression() != null) {
            contribution.setAttribute("if", cd.getConditionalExpression());
        }
        if ((parameters = cd.getElements()) != null) {
            Iterator i = parameters.iterator();
            while (i.hasNext()) {
                Element parameter = (Element)i.next();
                org.w3c.dom.Element element = this.getParamterElement(parameter);
                contribution.appendChild(element);
            }
        }
        contribution.appendChild(this._document.createTextNode(cd.getAnnotation()));
        return contribution;
    }

    private org.w3c.dom.Element getImplementationElement(ImplementationDescriptor id) {
        List interceptors;
        org.w3c.dom.Element implementation = this._document.createElement("implementation");
        implementation.setAttribute("service-id", this.qualify(id.getServiceId()));
        if (id.getConditionalExpression() != null) {
            implementation.setAttribute("if", id.getConditionalExpression());
        }
        implementation.appendChild(this._document.createTextNode(id.getAnnotation()));
        InstanceBuilder ib = id.getInstanceBuilder();
        if (ib != null) {
            org.w3c.dom.Element instanceBuilder = this.getInstanceBuilderElement(ib);
            implementation.appendChild(instanceBuilder);
        }
        if ((interceptors = id.getInterceptors()) != null) {
            Iterator i = interceptors.iterator();
            while (i.hasNext()) {
                InterceptorDescriptor icd = (InterceptorDescriptor)i.next();
                org.w3c.dom.Element interceptor = this.getInterceptorElement(icd);
                implementation.appendChild(interceptor);
            }
        }
        return implementation;
    }

    private org.w3c.dom.Element getSubModuleElement(SubModuleDescriptor smd) {
        org.w3c.dom.Element subModule = this._document.createElement("sub-module");
        subModule.setAttribute("descriptor", smd.getDescriptor().getPath());
        return subModule;
    }

    private org.w3c.dom.Element getInstanceBuilderElement(InstanceBuilder ib) {
        org.w3c.dom.Element instanceBuilder;
        if (ib instanceof CreateInstanceDescriptor) {
            CreateInstanceDescriptor cid = (CreateInstanceDescriptor)ib;
            instanceBuilder = this._document.createElement("create-instance");
            instanceBuilder.setAttribute("class", cid.getInstanceClassName());
            if (!cid.getServiceModel().equals("singleton")) {
                instanceBuilder.setAttribute("model", cid.getServiceModel());
            }
        } else {
            List parameters;
            InvokeFactoryDescriptor ifd = (InvokeFactoryDescriptor)ib;
            instanceBuilder = this._document.createElement("invoke-factory");
            if (!ifd.getFactoryServiceId().equals("hivemind.BuilderFactory")) {
                instanceBuilder.setAttribute("service-id", this.qualify(ifd.getFactoryServiceId()));
            }
            if (ifd.getServiceModel() != null) {
                instanceBuilder.setAttribute("model", ifd.getServiceModel());
            }
            if ((parameters = ifd.getParameters()) != null) {
                Iterator i = parameters.iterator();
                while (i.hasNext()) {
                    Element parameter = (Element)i.next();
                    org.w3c.dom.Element element = this.getParamterElement(parameter);
                    instanceBuilder.appendChild(element);
                }
            }
        }
        return instanceBuilder;
    }

    private org.w3c.dom.Element getInterceptorElement(InterceptorDescriptor icd) {
        org.w3c.dom.Element interceptor = this._document.createElement("interceptor");
        interceptor.setAttribute("service-id", this.qualify(icd.getFactoryServiceId()));
        if (icd.getBefore() != null) {
            interceptor.setAttribute("before", icd.getBefore());
        }
        if (icd.getAfter() != null) {
            interceptor.setAttribute("after", icd.getAfter());
        }
        return interceptor;
    }

    private org.w3c.dom.Element getParamterElement(Element parameter) {
        org.w3c.dom.Element element = this._document.createElement(parameter.getElementName());
        List attributes = parameter.getAttributes();
        Iterator i = attributes.iterator();
        while (i.hasNext()) {
            Attribute attribute = (Attribute)i.next();
            element.setAttribute(attribute.getName(), attribute.getValue());
        }
        List elements = parameter.getElements();
        Iterator i2 = elements.iterator();
        while (i2.hasNext()) {
            Element nestedParameter = (Element)i2.next();
            element.appendChild(this.getParamterElement(nestedParameter));
        }
        return element;
    }

    private void addSchema(org.w3c.dom.Element container, SchemaImpl s, String elementName) {
        if (this._processedSchemas.contains(s)) {
            return;
        }
        org.w3c.dom.Element schema = this._document.createElement(elementName);
        if (s.getId() != null) {
            schema.setAttribute("id", this.qualify(s.getId()));
        }
        if (s.getVisibility() == Visibility.PRIVATE) {
            schema.setAttribute("visibility", "private");
        }
        schema.appendChild(this._document.createTextNode(s.getAnnotation()));
        Iterator j = s.getElementModel().iterator();
        while (j.hasNext()) {
            ElementModel em = (ElementModel)j.next();
            org.w3c.dom.Element element = this.getElementElement(em);
            schema.appendChild(element);
        }
        container.appendChild(schema);
        this._processedSchemas.add(s);
    }

    private org.w3c.dom.Element getRulesElement(ElementModel em) {
        org.w3c.dom.Element rules = this._document.createElement("rules");
        Iterator i = em.getRules().iterator();
        while (i.hasNext()) {
            BaseRule spr;
            Rule r = (Rule)i.next();
            org.w3c.dom.Element rule = null;
            if (r instanceof CreateObjectRule) {
                CreateObjectRule cor = (CreateObjectRule)r;
                rule = this._document.createElement("create-object");
                rule.setAttribute("class", cor.getClassName());
            } else if (r instanceof InvokeParentRule) {
                InvokeParentRule ipr = (InvokeParentRule)r;
                rule = this._document.createElement("invoke-parent");
                rule.setAttribute("method", ipr.getMethodName());
                if (ipr.getDepth() != 1) {
                    rule.setAttribute("depth", Integer.toString(ipr.getDepth()));
                }
            } else if (r instanceof PushAttributeRule) {
                PushAttributeRule par = (PushAttributeRule)r;
                rule = this._document.createElement("push-attribute");
                rule.setAttribute("attribute", par.getAttributeName());
            } else if (r instanceof PushContentRule) {
                rule = this._document.createElement("push-content");
            } else if (r instanceof ReadAttributeRule) {
                ReadAttributeRule rar = (ReadAttributeRule)r;
                rule = this._document.createElement("read-attribute");
                rule.setAttribute("property", rar.getPropertyName());
                rule.setAttribute("attribute", rar.getAttributeName());
                if (!rar.getSkipIfNull()) {
                    rule.setAttribute("skip-if-null", "false");
                }
                if (rar.getTranslator() != null) {
                    rule.setAttribute("translator", rar.getTranslator());
                }
            } else if (r instanceof ReadContentRule) {
                ReadContentRule rcr = (ReadContentRule)r;
                rule = this._document.createElement("read-content");
                rule.setAttribute("property", rcr.getPropertyName());
            } else if (r instanceof SetModuleRule) {
                SetModuleRule smr = (SetModuleRule)r;
                rule = this._document.createElement("set-module");
                rule.setAttribute("property", smr.getPropertyName());
            } else if (r instanceof SetParentRule) {
                spr = (SetParentRule)r;
                rule = this._document.createElement("set-parent");
                rule.setAttribute("property", ((SetParentRule)spr).getPropertyName());
            } else if (r instanceof SetPropertyRule) {
                spr = (SetPropertyRule)r;
                rule = this._document.createElement("set-property");
                rule.setAttribute("property", ((SetPropertyRule)spr).getPropertyName());
                rule.setAttribute("value", ((SetPropertyRule)spr).getValue());
            } else if (r instanceof ConversionDescriptor) {
                ConversionDescriptor cd = (ConversionDescriptor)r;
                rule = this._document.createElement("conversion");
                rule.setAttribute("class", cd.getClassName());
                if (!cd.getParentMethodName().equals("addElement")) {
                    rule.setAttribute("parent-method", cd.getParentMethodName());
                }
                Iterator j = cd.getAttributeMappings().iterator();
                while (j.hasNext()) {
                    AttributeMappingDescriptor amd = (AttributeMappingDescriptor)j.next();
                    org.w3c.dom.Element map = this._document.createElement("map");
                    map.setAttribute("attribute", amd.getAttributeName());
                    map.setAttribute("property", amd.getPropertyName());
                    rule.appendChild(map);
                }
            } else {
                rule = this._document.createElement("custom");
                rule.setAttribute("class", r.getClass().getName());
            }
            if (rule == null) continue;
            rules.appendChild(rule);
        }
        return rules;
    }

    private org.w3c.dom.Element getElementElement(ElementModel em) {
        org.w3c.dom.Element element = this._document.createElement("element");
        element.setAttribute("name", em.getElementName());
        element.appendChild(this._document.createTextNode(em.getAnnotation()));
        Iterator i = em.getAttributeModels().iterator();
        while (i.hasNext()) {
            AttributeModel am = (AttributeModel)i.next();
            org.w3c.dom.Element attribute = this.getAttributeElement(am);
            element.appendChild(attribute);
        }
        i = em.getElementModel().iterator();
        while (i.hasNext()) {
            ElementModel nestedEm = (ElementModel)i.next();
            org.w3c.dom.Element nestedElement = this.getElementElement(nestedEm);
            element.appendChild(nestedElement);
        }
        if (!em.getRules().isEmpty()) {
            org.w3c.dom.Element rules = this.getRulesElement(em);
            element.appendChild(rules);
        }
        return element;
    }

    private org.w3c.dom.Element getAttributeElement(AttributeModel am) {
        org.w3c.dom.Element attribute = this._document.createElement("attribute");
        attribute.setAttribute("name", am.getName());
        if (am.isRequired()) {
            attribute.setAttribute("required", "true");
        }
        if (am.isUnique()) {
            attribute.setAttribute("unique", "true");
        }
        if (!am.getTranslator().equals("smart")) {
            attribute.setAttribute("translator", am.getTranslator());
        }
        attribute.appendChild(this._document.createTextNode(am.getAnnotation()));
        return attribute;
    }

    private String qualify(String id) {
        return IdUtils.qualify(this._md.getModuleId(), id);
    }

    private DocumentBuilder getBuilder() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringComments(true);
        try {
            return factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new ApplicationRuntimeException(e);
        }
    }

    public static Document createDefaultRegistryDocument() {
        DefaultClassResolver resolver = new DefaultClassResolver();
        XmlModuleDescriptorProvider provider = new XmlModuleDescriptorProvider(resolver);
        RegistrySerializer serializer = new RegistrySerializer();
        serializer.addModuleDescriptorProvider(provider);
        return serializer.createRegistryDocument();
    }
}

