/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hivemind.impl;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hivemind.impl.AbstractMessages;

public class MessageFormatter
extends AbstractMessages {
    private Log _log;
    private ResourceBundle _bundle;

    public MessageFormatter(Log log, ResourceBundle bundle) {
        this._log = log;
        this._bundle = bundle;
    }

    public MessageFormatter(Class referenceClass) {
        this(referenceClass, MessageFormatter.getStringsName(referenceClass));
    }

    public MessageFormatter(Class referenceClass, String name) {
        this(LogFactory.getLog((Class)referenceClass), referenceClass, name);
    }

    public MessageFormatter(Log log, Class referenceClass, String name) {
        this(log, MessageFormatter.getResourceBundleName(referenceClass, name));
    }

    public MessageFormatter(Log log, String bundleName) {
        this(log, ResourceBundle.getBundle(bundleName));
    }

    protected String findMessage(String key) {
        try {
            return this._bundle.getString(key);
        }
        catch (MissingResourceException ex) {
            this._log.error((Object)("Missing resource key: " + key + "."));
            return null;
        }
    }

    protected Locale getLocale() {
        return Locale.getDefault();
    }

    private static String getStringsName(Class referenceClass) {
        String className = referenceClass.getName();
        int lastDotIndex = className.lastIndexOf(46);
        String justClass = className.substring(lastDotIndex + 1);
        int mpos = justClass.indexOf("Messages");
        return justClass.substring(0, mpos) + "Strings";
    }

    private static String getResourceBundleName(Class referenceClass, String name) {
        int lastDotIndex;
        String packageName = null;
        packageName = referenceClass.getPackage() != null ? referenceClass.getPackage().getName() : ((lastDotIndex = referenceClass.getName().lastIndexOf(46)) == -1 ? "" : referenceClass.getName().substring(0, lastDotIndex));
        return packageName.equals("") ? name : packageName + "." + name;
    }
}

