/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hivemind.impl.servicemodel;

import java.util.ArrayList;
import java.util.List;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.PoolManageable;
import org.apache.hivemind.ShutdownCoordinator;
import org.apache.hivemind.events.RegistryShutdownListener;
import org.apache.hivemind.impl.ConstructableServicePoint;
import org.apache.hivemind.impl.ProxyUtils;
import org.apache.hivemind.impl.servicemodel.AbstractServiceModelImpl;
import org.apache.hivemind.impl.servicemodel.ServiceModelMessages;
import org.apache.hivemind.internal.Module;
import org.apache.hivemind.service.ThreadCleanupListener;
import org.apache.hivemind.service.ThreadEventNotifier;

public class PooledServiceModel
extends AbstractServiceModelImpl {
    protected static final String SERVICE_ACCESSOR_METHOD_NAME = "_service";
    private Object _serviceProxy;
    private ThreadEventNotifier _notifier;
    private ThreadLocal _activeService;
    private List _servicePool;
    private Class _serviceInterface;
    private static final PoolManageable NULL_MANAGEABLE = new PoolManageable(){

        public void activateService() {
        }

        public void passivateService() {
        }
    };
    static /* synthetic */ Class class$org$apache$hivemind$service$ThreadEventNotifier;

    public PooledServiceModel(ConstructableServicePoint servicePoint) {
        super(servicePoint);
        this._serviceInterface = servicePoint.getServiceInterface();
    }

    public synchronized Object getService() {
        if (this._notifier == null) {
            Module module = this.getServicePoint().getModule();
            this._notifier = (ThreadEventNotifier)module.getService("hivemind.ThreadEventNotifier", class$org$apache$hivemind$service$ThreadEventNotifier == null ? (class$org$apache$hivemind$service$ThreadEventNotifier = PooledServiceModel.class$("org.apache.hivemind.service.ThreadEventNotifier")) : class$org$apache$hivemind$service$ThreadEventNotifier);
        }
        if (this._serviceProxy == null) {
            this._serviceProxy = this.constructServiceProxy();
        }
        return this._serviceProxy;
    }

    private Object constructServiceProxy() {
        ConstructableServicePoint servicePoint = this.getServicePoint();
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Creating PooledProxy for service " + servicePoint.getExtensionPointId()));
        }
        Object proxy = ProxyUtils.createDelegatingProxy("PooledProxy", this, "getServiceImplementationForCurrentThread", servicePoint);
        Object intercepted = this.addInterceptors(proxy);
        RegistryShutdownListener outerProxy = ProxyUtils.createOuterProxy(intercepted, servicePoint);
        ShutdownCoordinator coordinator = servicePoint.getShutdownCoordinator();
        coordinator.addRegistryShutdownListener(outerProxy);
        return outerProxy;
    }

    public synchronized Object getServiceImplementationForCurrentThread() {
        PooledService pooled;
        if (this._activeService == null) {
            this._activeService = new ThreadLocal();
        }
        if ((pooled = (PooledService)this._activeService.get()) == null) {
            pooled = this.obtainPooledService();
            pooled.activate();
            this._notifier.addThreadCleanupListener(pooled);
            this._activeService.set(pooled);
        }
        return pooled.getService();
    }

    private PooledService obtainPooledService() {
        PooledService result = this.getServiceFromPool();
        if (result == null) {
            result = this.constructPooledService();
        }
        return result;
    }

    private synchronized PooledService getServiceFromPool() {
        int count;
        int n = count = this._servicePool == null ? 0 : this._servicePool.size();
        if (count == 0) {
            return null;
        }
        return (PooledService)this._servicePool.remove(count - 1);
    }

    private synchronized void returnServiceToPool(PooledService pooled) {
        if (this._servicePool == null) {
            this._servicePool = new ArrayList();
        }
        this._servicePool.add(pooled);
    }

    private synchronized PooledService constructPooledService() {
        try {
            Object core = this.constructCoreServiceImplementation();
            if (!this._serviceInterface.isInstance(core)) {
                core = this.constructBridgeProxy(core);
            }
            if (core instanceof RegistryShutdownListener) {
                this.getShutdownCoordinatorService().addRegistryShutdownListener((RegistryShutdownListener)core);
            }
            return new PooledService(core);
        }
        catch (Exception ex) {
            throw new ApplicationRuntimeException(ServiceModelMessages.unableToConstructService(this.getServicePoint(), ex), ex);
        }
    }

    private void unbindPooledServiceFromCurrentThread(PooledService pooled) {
        this._notifier.removeThreadCleanupListener(pooled);
        this._activeService.set(null);
        pooled.passivate();
        this.returnServiceToPool(pooled);
    }

    public void instantiateService() {
        this.getServiceImplementationForCurrentThread();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class PooledService
    implements ThreadCleanupListener {
        private Object _core;
        private PoolManageable _managed;

        PooledService(Object core) {
            this._core = core;
            this._managed = core instanceof PoolManageable ? (PoolManageable)core : NULL_MANAGEABLE;
        }

        public void threadDidCleanup() {
            PooledServiceModel.this.unbindPooledServiceFromCurrentThread(this);
        }

        void activate() {
            this._managed.activateService();
        }

        void passivate() {
            this._managed.passivateService();
        }

        public Object getService() {
            return this._core;
        }
    }
}

