/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hivemind.impl.servicemodel;

import java.lang.reflect.Constructor;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.events.RegistryShutdownListener;
import org.apache.hivemind.impl.ConstructableServicePoint;
import org.apache.hivemind.impl.ProxyBuilder;
import org.apache.hivemind.impl.servicemodel.AbstractServiceModelImpl;
import org.apache.hivemind.impl.servicemodel.SingletonInnerProxy;
import org.apache.hivemind.service.BodyBuilder;
import org.apache.hivemind.service.ClassFab;
import org.apache.hivemind.service.MethodSignature;

public final class SingletonServiceModel
extends AbstractServiceModelImpl {
    protected static final String SERVICE_ACCESSOR_METHOD_NAME = "_service";
    private Object _serviceProxy;
    private SingletonInnerProxy _innerProxy;
    private Object _constructedService;
    static /* synthetic */ Class class$org$apache$hivemind$events$RegistryShutdownListener;
    static /* synthetic */ Class class$org$apache$hivemind$impl$servicemodel$SingletonInnerProxy;

    public SingletonServiceModel(ConstructableServicePoint servicePoint) {
        super(servicePoint);
    }

    public synchronized Object getService() {
        if (this._serviceProxy == null) {
            this._serviceProxy = this.createSingletonProxy();
        }
        return this._serviceProxy;
    }

    public synchronized Object getActualServiceImplementation() {
        Class serviceInterface;
        if (this._constructedService == null) {
            this._constructedService = this.constructServiceImplementation();
        }
        if (this._constructedService instanceof RegistryShutdownListener) {
            this.getShutdownCoordinatorService().addRegistryShutdownListener((RegistryShutdownListener)this._constructedService);
        }
        if (!(serviceInterface = this.getServicePoint().getServiceInterface()).isInstance(this._constructedService)) {
            this._constructedService = this.constructBridgeProxy(this._constructedService);
        }
        return this._constructedService;
    }

    private Object createSingletonProxy() {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Creating SingletonProxy for service " + this.getServicePoint().getExtensionPointId()));
        }
        try {
            Class proxyClass = this.createSingletonProxyClass();
            Class innerProxyClass = this.createInnerProxyClass(proxyClass);
            Object result = proxyClass.newInstance();
            Constructor c = innerProxyClass.getConstructor(proxyClass, this.getClass());
            this._innerProxy = (SingletonInnerProxy)c.newInstance(result, this);
            this.getServicePoint().getShutdownCoordinator().addRegistryShutdownListener((RegistryShutdownListener)result);
            return result;
        }
        catch (Exception ex) {
            throw new ApplicationRuntimeException(ex);
        }
    }

    private Class createSingletonProxyClass() {
        ConstructableServicePoint servicePoint = this.getServicePoint();
        ProxyBuilder proxyBuilder = new ProxyBuilder("SingletonProxy", servicePoint, true);
        ClassFab classFab = proxyBuilder.getClassFab();
        Class serviceInterface = servicePoint.getServiceInterface();
        classFab.addField("_inner", serviceInterface);
        classFab.addField("_shutdown", Boolean.TYPE);
        if (!(class$org$apache$hivemind$events$RegistryShutdownListener == null ? (class$org$apache$hivemind$events$RegistryShutdownListener = SingletonServiceModel.class$("org.apache.hivemind.events.RegistryShutdownListener")) : class$org$apache$hivemind$events$RegistryShutdownListener).isAssignableFrom(serviceInterface)) {
            classFab.addInterface(class$org$apache$hivemind$events$RegistryShutdownListener == null ? (class$org$apache$hivemind$events$RegistryShutdownListener = SingletonServiceModel.class$("org.apache.hivemind.events.RegistryShutdownListener")) : class$org$apache$hivemind$events$RegistryShutdownListener);
            classFab.addMethod(17, new MethodSignature(Void.TYPE, "registryDidShutdown", null, null), "{ _shutdown = true; }");
        }
        classFab.addMethod(49, new MethodSignature(Void.TYPE, "_setInner", new Class[]{serviceInterface}, null), "{ _inner = $1; }");
        BodyBuilder builder = new BodyBuilder();
        builder.begin();
        builder.addln("if (_shutdown)");
        builder.begin();
        builder.addln("_inner = null;");
        builder.addln("throw org.apache.hivemind.HiveMind#createRegistryShutdownException();");
        builder.end();
        builder.addln("return _inner;");
        builder.end();
        classFab.addMethod(2, new MethodSignature(serviceInterface, "_getInner", null, null), builder.toString());
        proxyBuilder.addServiceMethods("_getInner()");
        return classFab.createClass();
    }

    private Class createInnerProxyClass(Class deferredProxyClass) {
        ConstructableServicePoint servicePoint = this.getServicePoint();
        Class serviceInterface = servicePoint.getServiceInterface();
        ProxyBuilder builder = new ProxyBuilder("InnerProxy", servicePoint);
        ClassFab classFab = builder.getClassFab();
        classFab.addField("_deferredProxy", deferredProxyClass);
        classFab.addField(SERVICE_ACCESSOR_METHOD_NAME, serviceInterface);
        classFab.addField("_serviceModel", this.getClass());
        BodyBuilder body = new BodyBuilder();
        body.begin();
        body.addln("super();");
        body.addln("_deferredProxy = $1;");
        body.addln("_serviceModel = $2;");
        body.addln("_deferredProxy._setInner(this);");
        body.end();
        classFab.addConstructor(new Class[]{deferredProxyClass, this.getClass()}, null, body.toString());
        body.clear();
        body.begin();
        body.add("if (_service == null)");
        body.begin();
        body.add("_service = (");
        body.add(serviceInterface.getName());
        body.addln(") _serviceModel.getActualServiceImplementation();");
        body.add("_deferredProxy._setInner(_service);");
        body.end();
        body.add("return _service;");
        body.end();
        classFab.addMethod(50, new MethodSignature(serviceInterface, SERVICE_ACCESSOR_METHOD_NAME, null, null), body.toString());
        builder.addServiceMethods("_service()");
        body.clear();
        body.begin();
        body.add("_service();");
        body.end();
        classFab.addMethod(17, new MethodSignature(Void.TYPE, "_instantiateServiceImplementation", null, null), body.toString());
        classFab.addInterface(class$org$apache$hivemind$impl$servicemodel$SingletonInnerProxy == null ? (class$org$apache$hivemind$impl$servicemodel$SingletonInnerProxy = SingletonServiceModel.class$("org.apache.hivemind.impl.servicemodel.SingletonInnerProxy")) : class$org$apache$hivemind$impl$servicemodel$SingletonInnerProxy);
        return classFab.createClass();
    }

    public void instantiateService() {
        this.getService();
        this._innerProxy._instantiateServiceImplementation();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

