/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.LogSequenceNumber;
import com.sleepycat.db.internal.DbEnv;

public final class ReplicationStatus {
    static final ReplicationStatus SUCCESS = new ReplicationStatus("SUCCESS", 0);
    private int errCode;
    private DatabaseEntry cdata;
    private int envid;
    private LogSequenceNumber lsn;
    private String statusName;
    private static final ReplicationStatus DUPMASTER = new ReplicationStatus("DUPMASTER", -30986);
    private static final ReplicationStatus HOLDELECTION = new ReplicationStatus("HOLDELECTION", -30984);

    private ReplicationStatus(String string, int n, DatabaseEntry databaseEntry, int n2, LogSequenceNumber logSequenceNumber) {
        this.statusName = string;
        this.errCode = n;
        this.cdata = databaseEntry;
        this.envid = n2;
        this.lsn = logSequenceNumber;
    }

    private ReplicationStatus(String string, int n) {
        this(string, n, null, 0, null);
    }

    public boolean isSuccess() {
        return this.errCode == 0;
    }

    public boolean isDupMaster() {
        return this.errCode == -30986;
    }

    public boolean isHoldElection() {
        return this.errCode == -30984;
    }

    public boolean isPermanent() {
        return this.errCode == -30983;
    }

    public boolean isNewMaster() {
        return this.errCode == -30982;
    }

    public boolean isNewSite() {
        return this.errCode == -30981;
    }

    public boolean isNotPermanent() {
        return this.errCode == -30980;
    }

    public boolean isStartupDone() {
        return this.errCode == -30979;
    }

    public DatabaseEntry getCData() {
        return this.cdata;
    }

    public int getEnvID() {
        return this.envid;
    }

    public LogSequenceNumber getLSN() {
        return this.lsn;
    }

    public String toString() {
        return "ReplicationStatus." + this.statusName;
    }

    static ReplicationStatus getStatus(int n, DatabaseEntry databaseEntry, int n2, LogSequenceNumber logSequenceNumber) {
        switch (n) {
            case 0: {
                return SUCCESS;
            }
            case -30986: {
                return DUPMASTER;
            }
            case -30984: {
                return HOLDELECTION;
            }
            case -30983: {
                return new ReplicationStatus("ISPERM", n, databaseEntry, n2, logSequenceNumber);
            }
            case -30982: {
                return new ReplicationStatus("NEWMASTER", n, databaseEntry, n2, logSequenceNumber);
            }
            case -30981: {
                return new ReplicationStatus("NEWSITE", n, databaseEntry, n2, logSequenceNumber);
            }
            case -30980: {
                return new ReplicationStatus("NOTPERM", n, databaseEntry, n2, logSequenceNumber);
            }
        }
        throw new IllegalArgumentException("Unknown error code: " + DbEnv.strerror(n));
    }
}

