/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.internal.DbEnv;
import com.sleepycat.db.internal.DbTxn;

public class TransactionConfig
implements Cloneable {
    public static final TransactionConfig DEFAULT = new TransactionConfig();
    private boolean dirtyRead = false;
    private boolean degree2 = false;
    private boolean noSync = false;
    private boolean noWait = false;
    private boolean sync = false;

    static TransactionConfig checkNull(TransactionConfig transactionConfig) {
        return transactionConfig == null ? DEFAULT : transactionConfig;
    }

    public void setDegree2(boolean bl) {
        this.degree2 = bl;
    }

    public boolean getDegree2() {
        return this.degree2;
    }

    public void setDirtyRead(boolean bl) {
        this.dirtyRead = bl;
    }

    public boolean getDirtyRead() {
        return this.dirtyRead;
    }

    public void setNoSync(boolean bl) {
        this.noSync = bl;
    }

    public boolean getNoSync() {
        return this.noSync;
    }

    public void setNoWait(boolean bl) {
        this.noWait = bl;
    }

    public boolean getNoWait() {
        return this.noWait;
    }

    public void setSync(boolean bl) {
        this.sync = bl;
    }

    public boolean getSync() {
        return this.sync;
    }

    DbTxn beginTransaction(DbEnv dbEnv, DbTxn dbTxn) throws DatabaseException {
        int n = 0;
        n |= this.degree2 ? 0x2000000 : 0;
        n |= this.dirtyRead ? 0x4000000 : 0;
        n |= this.noSync ? 256 : 0;
        n |= this.noWait ? 4096 : 0;
        return dbEnv.txn_begin(dbTxn, n |= this.sync ? 8192 : 0);
    }
}

