/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.collections;

import com.sleepycat.bind.EntityBinding;
import com.sleepycat.bind.EntryBinding;
import com.sleepycat.bind.RecordNumberBinding;
import com.sleepycat.collections.CurrentTransaction;
import com.sleepycat.collections.DataCursor;
import com.sleepycat.collections.KeyRange;
import com.sleepycat.collections.KeyRangeException;
import com.sleepycat.collections.PrimaryKeyAssigner;
import com.sleepycat.compat.DbCompat;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.JoinConfig;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.SecondaryConfig;
import com.sleepycat.je.SecondaryDatabase;
import com.sleepycat.je.SecondaryKeyCreator;
import com.sleepycat.je.Transaction;
import com.sleepycat.util.RuntimeExceptionWrapper;

final class DataView
implements Cloneable {
    Database db;
    SecondaryDatabase secDb;
    CurrentTransaction currentTxn;
    KeyRange range;
    EntryBinding keyBinding;
    EntryBinding valueBinding;
    EntityBinding entityBinding;
    PrimaryKeyAssigner keyAssigner;
    SecondaryKeyCreator secKeyCreator;
    CursorConfig cursorConfig;
    boolean writeAllowed;
    boolean ordered;
    boolean recNumAllowed;
    boolean recNumAccess;
    boolean btreeRecNumDb;
    boolean btreeRecNumAccess;
    boolean recNumRenumber;
    boolean keysRenumbered;
    boolean dupsAllowed;
    boolean dupsOrdered;
    boolean transactional;
    boolean readUncommittedAllowed;

    DataView(Database database, EntryBinding keyBinding, EntryBinding valueBinding, EntityBinding entityBinding, boolean writeAllowed, PrimaryKeyAssigner keyAssigner) throws IllegalArgumentException {
        if (database == null) {
            throw new IllegalArgumentException("database is null");
        }
        this.db = database;
        try {
            DatabaseConfig dbConfig;
            this.currentTxn = CurrentTransaction.getInstanceInternal(this.db.getEnvironment());
            if (this.db instanceof SecondaryDatabase) {
                this.secDb = (SecondaryDatabase)database;
                SecondaryConfig secConfig = this.secDb.getSecondaryConfig();
                this.secKeyCreator = secConfig.getKeyCreator();
                dbConfig = secConfig;
            } else {
                dbConfig = this.db.getConfig();
            }
            this.ordered = !DbCompat.isTypeHash(dbConfig);
            this.recNumAllowed = DbCompat.isTypeQueue(dbConfig) || DbCompat.isTypeRecno(dbConfig) || DbCompat.getBtreeRecordNumbers(dbConfig);
            this.recNumRenumber = DbCompat.getRenumbering(dbConfig);
            this.dupsAllowed = DbCompat.getSortedDuplicates(dbConfig) || DbCompat.getUnsortedDuplicates(dbConfig);
            this.dupsOrdered = DbCompat.getSortedDuplicates(dbConfig);
            this.transactional = this.currentTxn.isTxnMode() && dbConfig.getTransactional();
            this.readUncommittedAllowed = DbCompat.getReadUncommitted(dbConfig);
            this.btreeRecNumDb = this.recNumAllowed && DbCompat.isTypeBtree(dbConfig);
            this.range = new KeyRange(dbConfig.getBtreeComparator());
        }
        catch (DatabaseException e) {
            throw new RuntimeExceptionWrapper(e);
        }
        this.writeAllowed = writeAllowed;
        this.keyBinding = keyBinding;
        this.valueBinding = valueBinding;
        this.entityBinding = entityBinding;
        this.keyAssigner = keyAssigner;
        this.cursorConfig = CursorConfig.DEFAULT;
        if (valueBinding != null && entityBinding != null) {
            throw new IllegalArgumentException("both valueBinding and entityBinding are non-null");
        }
        if (keyBinding instanceof RecordNumberBinding) {
            if (!this.recNumAllowed) {
                throw new IllegalArgumentException("RecordNumberBinding requires DB_BTREE/DB_RECNUM, DB_RECNO, or DB_QUEUE");
            }
            this.recNumAccess = true;
            if (this.btreeRecNumDb) {
                this.btreeRecNumAccess = true;
            }
        }
        this.keysRenumbered = this.recNumRenumber || this.btreeRecNumAccess;
    }

    private DataView cloneView() {
        try {
            return (DataView)super.clone();
        }
        catch (CloneNotSupportedException willNeverOccur) {
            throw new IllegalStateException();
        }
    }

    DataView keySetView() {
        if (this.keyBinding == null) {
            throw new UnsupportedOperationException("must have keyBinding");
        }
        DataView view = this.cloneView();
        view.valueBinding = null;
        view.entityBinding = null;
        return view;
    }

    DataView valueSetView() {
        if (this.valueBinding == null && this.entityBinding == null) {
            throw new UnsupportedOperationException("must have valueBinding or entityBinding");
        }
        DataView view = this.cloneView();
        view.keyBinding = null;
        return view;
    }

    DataView valueSetView(Object singleKey) throws DatabaseException, KeyRangeException {
        KeyRange singleKeyRange = this.subRange(singleKey);
        DataView view = this.valueSetView();
        view.range = singleKeyRange;
        return view;
    }

    DataView subView(Object beginKey, boolean beginInclusive, Object endKey, boolean endInclusive, EntryBinding keyBinding) throws DatabaseException, KeyRangeException {
        DataView view = this.cloneView();
        view.setRange(beginKey, beginInclusive, endKey, endInclusive);
        if (keyBinding != null) {
            view.keyBinding = keyBinding;
        }
        return view;
    }

    DataView configuredView(CursorConfig config) {
        DataView view = this.cloneView();
        view.cursorConfig = config != null ? DbCompat.cloneCursorConfig(config) : CursorConfig.DEFAULT;
        return view;
    }

    CurrentTransaction getCurrentTxn() {
        return this.transactional ? this.currentTxn : null;
    }

    private void setRange(Object beginKey, boolean beginInclusive, Object endKey, boolean endInclusive) throws DatabaseException, KeyRangeException {
        this.range = this.subRange(beginKey, beginInclusive, endKey, endInclusive);
    }

    DatabaseEntry getSingleKeyThang() {
        return this.range.getSingleKey();
    }

    final Environment getEnv() {
        return this.currentTxn.getEnvironment();
    }

    final boolean isSecondary() {
        return this.secDb != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isEmpty() throws DatabaseException {
        DataCursor cursor = new DataCursor(this, false);
        try {
            boolean bl = cursor.getFirst(false) != OperationStatus.SUCCESS;
            return bl;
        }
        finally {
            cursor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OperationStatus append(Object value, Object[] retPrimaryKey, Object[] retValue) throws DatabaseException {
        OperationStatus status;
        DatabaseEntry keyThang = new DatabaseEntry();
        DatabaseEntry valueThang = new DatabaseEntry();
        this.useValue(value, valueThang, null);
        if (this.keyAssigner != null) {
            this.keyAssigner.assignKey(keyThang);
            if (!this.range.check(keyThang)) {
                throw new IllegalArgumentException("assigned key out of range");
            }
            DataCursor cursor = new DataCursor(this, true);
            try {
                status = cursor.getCursor().putNoOverwrite(keyThang, valueThang);
            }
            finally {
                cursor.close();
            }
        } else {
            if (this.currentTxn.isCDBCursorOpen(this.db)) {
                throw new IllegalStateException("cannot open CDB write cursor when read cursor is open");
            }
            status = DbCompat.append(this.db, this.useTransaction(), keyThang, valueThang);
            if (status == OperationStatus.SUCCESS && !this.range.check(keyThang)) {
                this.db.delete(this.useTransaction(), keyThang);
                throw new IllegalArgumentException("appended record number out of range");
            }
        }
        if (status == OperationStatus.SUCCESS) {
            this.returnPrimaryKeyAndValue(keyThang, valueThang, retPrimaryKey, retValue);
        }
        return status;
    }

    Transaction useTransaction() {
        return this.transactional ? this.currentTxn.getTransaction() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear() throws DatabaseException {
        DataCursor cursor = new DataCursor(this, true);
        try {
            OperationStatus status = OperationStatus.SUCCESS;
            while (status == OperationStatus.SUCCESS) {
                status = this.keysRenumbered ? cursor.getFirst(true) : cursor.getNext(true);
                if (status != OperationStatus.SUCCESS) continue;
                cursor.delete();
            }
        }
        finally {
            cursor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DataCursor join(DataView[] indexViews, Object[] indexKeys, JoinConfig joinConfig) throws DatabaseException {
        DataCursor joinCursor = null;
        DataCursor[] indexCursors = new DataCursor[indexViews.length];
        try {
            for (int i = 0; i < indexViews.length; ++i) {
                indexCursors[i] = new DataCursor(indexViews[i], false);
                indexCursors[i].getSearchKey(indexKeys[i], null, false);
            }
            DataCursor dataCursor = joinCursor = new DataCursor(this, indexCursors, joinConfig, true);
            return dataCursor;
        }
        finally {
            if (joinCursor == null) {
                for (int i = 0; i < indexCursors.length; ++i) {
                    if (indexCursors[i] == null) continue;
                    try {
                        indexCursors[i].close();
                        continue;
                    }
                    catch (Exception e) {}
                }
            }
        }
    }

    DataCursor join(DataCursor[] indexCursors, JoinConfig joinConfig) throws DatabaseException {
        return new DataCursor(this, indexCursors, joinConfig, false);
    }

    private void returnPrimaryKeyAndValue(DatabaseEntry keyThang, DatabaseEntry valueThang, Object[] retPrimaryKey, Object[] retValue) throws DatabaseException {
        if (retPrimaryKey != null) {
            if (this.keyBinding == null) {
                throw new IllegalArgumentException("returning key requires primary key binding");
            }
            if (this.isSecondary()) {
                throw new IllegalArgumentException("returning key requires unindexed view");
            }
            retPrimaryKey[0] = this.keyBinding.entryToObject(keyThang);
        }
        if (retValue != null) {
            retValue[0] = this.makeValue(keyThang, valueThang);
        }
    }

    boolean useKey(Object key, Object value, DatabaseEntry keyThang, KeyRange checkRange) throws DatabaseException {
        if (key != null) {
            if (this.keyBinding == null) {
                throw new IllegalArgumentException("non-null key with null key binding");
            }
            this.keyBinding.objectToEntry(key, keyThang);
        } else {
            if (value == null) {
                throw new IllegalArgumentException("null key and null value");
            }
            if (this.entityBinding == null) {
                throw new IllegalStateException("EntityBinding required to derive key from value");
            }
            if (this.isSecondary()) {
                DatabaseEntry primaryKeyThang = new DatabaseEntry();
                this.entityBinding.objectToKey(value, primaryKeyThang);
                DatabaseEntry valueThang = new DatabaseEntry();
                this.entityBinding.objectToData(value, valueThang);
                this.secKeyCreator.createSecondaryKey(this.secDb, primaryKeyThang, valueThang, keyThang);
            } else {
                this.entityBinding.objectToKey(value, keyThang);
            }
        }
        if (this.recNumAccess && DbCompat.getRecordNumber(keyThang) <= 0) {
            return false;
        }
        return checkRange == null || checkRange.check(keyThang);
    }

    final boolean canDeriveKeyFromValue() {
        return this.entityBinding != null;
    }

    /*
     * Enabled aggressive block sorting
     */
    void useValue(Object value, DatabaseEntry valueThang, DatabaseEntry checkKeyThang) throws DatabaseException {
        if (value == null) {
            valueThang.setData(new byte[0]);
            valueThang.setOffset(0);
            valueThang.setSize(0);
            return;
        }
        if (this.valueBinding != null) {
            this.valueBinding.objectToEntry(value, valueThang);
            return;
        }
        if (this.entityBinding == null) throw new IllegalArgumentException("non-null value with null value/entity binding");
        this.entityBinding.objectToData(value, valueThang);
        if (checkKeyThang == null) return;
        DatabaseEntry thang = new DatabaseEntry();
        this.entityBinding.objectToKey(value, thang);
        if (KeyRange.equalBytes(thang, checkKeyThang)) return;
        throw new IllegalArgumentException("cannot change primary key");
    }

    Object makeKey(DatabaseEntry keyThang) throws DatabaseException {
        if (keyThang.getSize() == 0) {
            return null;
        }
        return this.keyBinding.entryToObject(keyThang);
    }

    Object makeValue(DatabaseEntry primaryKeyThang, DatabaseEntry valueThang) throws DatabaseException {
        Object value;
        if (this.valueBinding != null) {
            value = this.valueBinding.entryToObject(valueThang);
        } else if (this.entityBinding != null) {
            value = this.entityBinding.entryToObject(primaryKeyThang, valueThang);
        } else {
            throw new UnsupportedOperationException("requires valueBinding or entityBinding");
        }
        return value;
    }

    KeyRange subRange(Object singleKey) throws DatabaseException, KeyRangeException {
        return this.range.subRange(this.makeRangeKey(singleKey));
    }

    KeyRange subRange(Object beginKey, boolean beginInclusive, Object endKey, boolean endInclusive) throws DatabaseException, KeyRangeException {
        if (beginKey == endKey && beginInclusive && endInclusive) {
            return this.subRange(beginKey);
        }
        if (!this.ordered) {
            throw new UnsupportedOperationException("Cannot use key ranges on an unsorted database");
        }
        DatabaseEntry beginThang = beginKey != null ? this.makeRangeKey(beginKey) : null;
        DatabaseEntry endThang = endKey != null ? this.makeRangeKey(endKey) : null;
        return this.range.subRange(beginThang, beginInclusive, endThang, endInclusive);
    }

    private DatabaseEntry makeRangeKey(Object key) throws DatabaseException {
        DatabaseEntry thang = new DatabaseEntry();
        if (this.keyBinding != null) {
            this.useKey(key, null, thang, null);
        } else {
            this.useKey(null, key, thang, null);
        }
        return thang;
    }
}

